/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import net.covers1624.coffeegrinder.bytecode.IndexedInstructionCollection;
import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.SimpleInsnVisitor;
import net.covers1624.coffeegrinder.bytecode.insns.Binary;
import net.covers1624.coffeegrinder.bytecode.insns.Comparison;
import net.covers1624.coffeegrinder.bytecode.insns.IfInstruction;
import net.covers1624.coffeegrinder.bytecode.insns.Invoke;
import net.covers1624.coffeegrinder.bytecode.insns.LdcBoolean;
import net.covers1624.coffeegrinder.bytecode.insns.LdcChar;
import net.covers1624.coffeegrinder.bytecode.insns.LdcNumber;
import net.covers1624.coffeegrinder.bytecode.insns.Load;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.insns.LogicNot;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.bytecode.insns.Reference;
import net.covers1624.coffeegrinder.bytecode.insns.Return;
import net.covers1624.coffeegrinder.bytecode.insns.Store;
import net.covers1624.coffeegrinder.bytecode.insns.SwitchTable;
import net.covers1624.coffeegrinder.bytecode.matching.LdcMatching;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformer;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.IntegerConstantType;
import net.covers1624.coffeegrinder.type.IntegerConstantUnion;
import net.covers1624.coffeegrinder.type.Parameter;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.type.TypeSystem;
import net.covers1624.coffeegrinder.util.None;
import net.covers1624.quack.collection.FastStream;

public class IntegerConstantInference
implements MethodTransformer {
    public static final IntegerConstantUnion BOOLEAN_CONSTANTS = new IntegerConstantUnion((List<IntegerConstantType>)ImmutableList.of((Object)new IntegerConstantType(0), (Object)new IntegerConstantType(1)));

    @Override
    public void transform(MethodDecl function, MethodTransformContext ctx) {
        function.accept(new Visitor(ctx), PrimitiveType.VOID);
    }

    public static boolean isBooleanConstant(AType type) {
        return TypeSystem.isAssignableTo(type, BOOLEAN_CONSTANTS);
    }

    private static class Visitor
    extends SimpleInsnVisitor<AType> {
        private final MethodTransformContext methodCtx;

        public Visitor(MethodTransformContext ctx) {
            this.methodCtx = ctx;
        }

        @Override
        public None visitDefault(Instruction insn, AType ctx) {
            return super.visitDefault(insn, PrimitiveType.VOID);
        }

        @Override
        public None visitLoad(Load load, AType ctx) {
            if (load.getReference().opcode != InsnOpcode.LOCAL_REFERENCE) {
                load.getReference().accept(this, PrimitiveType.VOID);
                return NONE;
            }
            LocalVariable variable = load.getVariable();
            if (TypeSystem.isIntegerConstant(variable.getType()) && !TypeSystem.isIntegerConstant(ctx)) {
                if (ctx == PrimitiveType.VOID) {
                    ctx = PrimitiveType.INT;
                }
                variable.setType(ctx);
                FastStream.of(variable.getReferences()).filter(Reference::isWrittenTo).forEach(e -> e.getParent().accept(this, PrimitiveType.VOID));
            }
            return NONE;
        }

        @Override
        public None visitLdcNumber(LdcNumber ldcNumber, AType ctx) {
            LdcNumber ldcInt = LdcMatching.matchLdcInt(ldcNumber);
            if (ldcInt == null) {
                return NONE;
            }
            int intValue = ldcInt.intValue();
            if (ctx == PrimitiveType.BOOLEAN) {
                assert (intValue == 0 || intValue == 1);
                ldcInt.replaceWith(new LdcBoolean(intValue == 1));
            }
            if (ctx == PrimitiveType.CHAR) {
                assert (intValue >= 0 && intValue <= 65535);
                ldcInt.replaceWith(new LdcChar((char)intValue));
            }
            return NONE;
        }

        @Override
        public None visitStore(Store store, AType ctx) {
            LocalVariable v;
            Reference r = store.getReference();
            if (r.opcode == InsnOpcode.LOCAL_REFERENCE && (v = store.getVariable()).isSynthetic() && v.getLoadCount() == 0 && TypeSystem.isIntegerConstant(v.getType())) {
                v.setType(IntegerConstantInference.isBooleanConstant(v.getType()) ? PrimitiveType.BOOLEAN : PrimitiveType.INT);
            }
            store.getValue().accept(this, r.getType());
            store.getReference().accept(this, PrimitiveType.VOID);
            return NONE;
        }

        @Override
        public None visitInvoke(Invoke invoke, AType ctx) {
            invoke.getTarget().accept(this, PrimitiveType.VOID);
            List<Parameter> parameters = invoke.getMethod().getParameters();
            IndexedInstructionCollection<Instruction> arguments = invoke.getArguments();
            for (int i = 0; i < arguments.size(); ++i) {
                arguments.get(i).accept(this, parameters.get(i).getType());
            }
            return NONE;
        }

        @Override
        public None visitReturn(Return ret, AType ctx) {
            ret.getValue().accept(this, ret.getMethod().getReturnType());
            return NONE;
        }

        @Override
        public None visitComparison(Comparison comparison, AType ctx) {
            AType leftType = comparison.getLeft().getResultType();
            AType rightType = comparison.getRight().getResultType();
            if (IntegerConstantInference.isBooleanConstant(leftType) && IntegerConstantInference.isBooleanConstant(rightType)) {
                leftType = PrimitiveType.BOOLEAN;
                rightType = PrimitiveType.BOOLEAN;
            } else if (TypeSystem.isIntegerConstant(leftType) && TypeSystem.isIntegerConstant(rightType)) {
                leftType = PrimitiveType.INT;
                rightType = PrimitiveType.INT;
            }
            comparison.getLeft().accept(this, rightType);
            comparison.getRight().accept(this, leftType);
            Comparison.ComparisonKind kind = comparison.getKind();
            if ((kind == Comparison.ComparisonKind.EQUAL || kind == Comparison.ComparisonKind.NOT_EQUAL) && LdcMatching.matchLdcBoolean(comparison.getRight(), false) != null) {
                if (kind == Comparison.ComparisonKind.EQUAL) {
                    this.methodCtx.pushStep("Unwrap boolean logic to not.");
                    comparison.replaceWith(new LogicNot(comparison.getLeft()));
                    this.methodCtx.popStep();
                } else {
                    this.methodCtx.pushStep("Unwrap boolean conversion.");
                    comparison.replaceWith(comparison.getLeft());
                    this.methodCtx.popStep();
                }
            }
            return NONE;
        }

        @Override
        public None visitIfInstruction(IfInstruction ifInsn, AType ctx) {
            ifInsn.getCondition().accept(this, PrimitiveType.BOOLEAN);
            ifInsn.getTrueInsn().accept(this, PrimitiveType.VOID);
            ifInsn.getFalseInsn().accept(this, PrimitiveType.VOID);
            return NONE;
        }

        @Override
        public None visitBinary(Binary binary, AType ctx) {
            AType resultType = binary.getResultType();
            if (binary.getOp().isLogic()) {
                resultType = ctx;
            }
            binary.getLeft().accept(this, resultType);
            binary.getRight().accept(this, resultType);
            return NONE;
        }

        @Override
        public None visitSwitchTable(SwitchTable switchTable, AType ctx) {
            super.visitSwitchTable(switchTable, ctx);
            AType type = switchTable.getValue().getResultType();
            Iterator<SwitchTable.SwitchSection> iterator = switchTable.sections.iterator();
            while (iterator.hasNext()) {
                SwitchTable.SwitchSection section = iterator.next();
                Iterator<Instruction> iterator2 = section.values.iterator();
                while (iterator2.hasNext()) {
                    Instruction value = iterator2.next();
                    value.accept(this, type);
                }
            }
            return NONE;
        }
    }
}

