/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.insns.BlockContainer;
import net.covers1624.coffeegrinder.bytecode.insns.Leave;
import org.jetbrains.annotations.Nullable;

public class TransformerUtils {
    public static void moveBlocksIntoContainer(Iterable<Block> blocks, BlockContainer fromContainer, BlockContainer toContainer, @Nullable Block exitBlock) {
        for (Block block : blocks) {
            BlockContainer parent = (BlockContainer)block.getParentOrNull();
            if (parent == null || parent == fromContainer) {
                Block target = (Block)toContainer.blocks.filter(e -> e.getBytecodeOffset() < block.getBytecodeOffset()).lastOrDefault();
                if (target != null) {
                    target.insertAfter(block);
                    continue;
                }
                toContainer.blocks.add(block);
                continue;
            }
            assert (parent.isDescendantOf(fromContainer));
        }
        if (exitBlock == null) {
            return;
        }
        exitBlock.getBranches().filter(e -> e.isDescendantOf(toContainer)).toLinkedList().forEach(e -> e.replaceWith(new Leave(toContainer).withOffsets((Instruction)e)));
    }
}

