/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.source;

import com.google.common.collect.ImmutableList;
import java.util.List;

public class LineBuffer {
    public static final LineBuffer EMPTY = LineBuffer.of((List<String>)ImmutableList.of());
    public final ImmutableList<String> lines;

    private LineBuffer(List<String> lines) {
        this.lines = ImmutableList.copyOf(lines);
    }

    public static LineBuffer of() {
        return EMPTY;
    }

    public static LineBuffer of(Object str) {
        return LineBuffer.of((List<String>)ImmutableList.of((Object)str.toString()));
    }

    public static LineBuffer of(List<String> lines) {
        return new LineBuffer(lines);
    }

    public LineBuffer prepend(String prepend) {
        if (prepend.isEmpty()) {
            return this;
        }
        if (this.lines.size() == 1) {
            return LineBuffer.of(prepend + (String)this.lines.get(0));
        }
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.add((Object)(prepend + (String)this.lines.get(0)));
        builder.addAll((Iterable)this.lines.subList(1, this.lines.size()));
        return LineBuffer.of((List<String>)builder.build());
    }

    public LineBuffer append(Object append) {
        String str = append.toString();
        if (this.lines.isEmpty()) {
            return LineBuffer.of((List<String>)ImmutableList.of((Object)str));
        }
        if (this.lines.size() == 1) {
            return LineBuffer.of((String)this.lines.get(0) + str);
        }
        if (str.isEmpty()) {
            return this;
        }
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)this.lines.size());
        builder.addAll((Iterable)this.lines.subList(0, this.lines.size() - 1));
        builder.add((Object)((String)this.lines.get(this.lines.size() - 1) + str));
        return LineBuffer.of((List<String>)builder.build());
    }

    public LineBuffer append(LineBuffer other) {
        return this.append("", other);
    }

    public LineBuffer append(String sep, LineBuffer other) {
        if (this.lines.isEmpty()) {
            return other.prepend(sep);
        }
        if (other.lines.isEmpty()) {
            return this.append(sep);
        }
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(this.lines.size() + other.lines.size()));
        builder.addAll((Iterable)this.lines.subList(0, this.lines.size() - 1));
        builder.add((Object)((String)this.lines.get(this.lines.size() - 1) + sep + (String)other.lines.get(0)));
        builder.addAll((Iterable)other.lines.subList(1, other.lines.size()));
        return LineBuffer.of((List<String>)builder.build());
    }

    public LineBuffer add(String line) {
        return LineBuffer.of((List<String>)ImmutableList.builderWithExpectedSize((int)(this.lines.size() + 1)).addAll(this.lines).add((Object)line).build());
    }

    public LineBuffer join(LineBuffer other) {
        if (this.lines.isEmpty()) {
            return other;
        }
        if (other.lines.isEmpty()) {
            return this;
        }
        return LineBuffer.of((List<String>)ImmutableList.builderWithExpectedSize((int)(this.lines.size() + other.lines.size())).addAll(this.lines).addAll(other.lines).build());
    }

    public LineBuffer joinOn(String seperator) {
        return LineBuffer.of(String.join((CharSequence)seperator, this.lines));
    }

    public String toString() {
        return String.join((CharSequence)"\n", this.lines);
    }
}

