/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.jdkutils;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Stream;
import net.covers1624.jdkutils.JavaInstall;
import net.covers1624.jdkutils.JavaVersion;
import net.covers1624.jdkutils.utils.Utils;
import net.covers1624.quack.annotation.Requires;
import net.covers1624.quack.collection.ColUtils;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.gson.JsonUtils;
import net.covers1624.quack.io.IOUtils;
import net.covers1624.quack.net.httpapi.RequestListener;
import net.covers1624.quack.platform.Architecture;
import net.covers1624.quack.platform.OperatingSystem;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires.RequiresList(value={@Requires(value="org.slf4j:slf4j-api"), @Requires(value="com.google.code.gson")})
public class JdkInstallationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdkInstallationManager.class);
    private static final Gson GSON = new Gson();
    private static final Type INSTALLS_TYPE = new TypeToken<List<Installation>>(){}.getType();
    private final Path baseDir;
    private final JdkProvisioner provisioner;
    private final Path manifestPath;
    private final List<Installation> installations;

    public JdkInstallationManager(Path baseDir, JdkProvisioner provisioner) {
        this.baseDir = baseDir;
        this.provisioner = provisioner;
        this.manifestPath = baseDir.resolve("installations.json");
        LOGGER.debug("Starting with baseDir {} manifestPath {}", (Object)baseDir, (Object)this.manifestPath);
        List<Installation> installs = new ArrayList<Installation>();
        if (Files.exists(this.manifestPath, new LinkOption[0])) {
            try {
                JsonElement parsed = (JsonElement)JsonUtils.parse((Gson)GSON, (Path)this.manifestPath, JsonElement.class, (Charset)StandardCharsets.UTF_8);
                if (parsed != null) {
                    installs = (List)GSON.fromJson(Installation.migrate(parsed), INSTALLS_TYPE);
                    LOGGER.debug("Loaded {} installs.", (Object)installs.size());
                    for (Installation install : installs) {
                        LOGGER.debug("  {}", (Object)install);
                    }
                }
            }
            catch (JsonParseException | IOException e) {
                LOGGER.error("Failed to parse json {}. Ignoring..", (Object)this.manifestPath, (Object)e);
            }
        }
        this.installations = installs;
        this.saveManifest();
        this.validateInstallations();
        this.validateInstallationsDir();
    }

    private void validateInstallations() {
        LOGGER.info("Validating java installations.");
        ListIterator<Installation> iterator = this.installations.listIterator();
        while (iterator.hasNext()) {
            Installation installation = iterator.next();
            LOGGER.debug("Checking install at {}", (Object)installation.path);
            if (!installation.isExecutable(this.baseDir)) {
                LOGGER.warn("Removing cache of un-executable installation at {}", (Object)installation.getPath(this.baseDir));
                iterator.remove();
                continue;
            }
            Path path = Paths.get(installation.path, new String[0]);
            if (!path.isAbsolute()) continue;
            LOGGER.info("Converting installation '{}' to relative paths.", (Object)installation.path);
            installation.path = this.baseDir.relativize(path).toString();
        }
        this.saveManifest();
    }

    private void validateInstallationsDir() {
        if (Files.notExists(this.baseDir, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> stream = Files.list(this.baseDir);){
            for (Path path : FastStream.of(stream)) {
                Installation newInstall;
                String rel;
                if (!Files.isDirectory(path, new LinkOption[0]) || ColUtils.anyMatch(this.installations, arg_0 -> JdkInstallationManager.lambda$validateInstallationsDir$0(rel = this.baseDir.relativize(path).toString(), arg_0)) || (newInstall = this.tryFindInstallation(path)) == null) continue;
                LOGGER.info("Recovered installation in {}", (Object)path);
                this.installations.add(newInstall);
            }
        }
        catch (IOException ex) {
            LOGGER.warn("Failed to scan installations dir.", (Throwable)ex);
        }
        this.saveManifest();
    }

    @Nullable
    private Installation tryFindInstallation(Path searchDir) {
        ArrayList folders;
        JavaInstall install = JavaInstall.parse(JavaInstall.getJavaExecutable(JavaInstall.getHomeDirectory(searchDir), true));
        if (install != null) {
            return new Installation(install.runtimeVersion, install.hasCompiler, install.architecture, this.hashInstallation(searchDir), this.baseDir.relativize(searchDir).toString());
        }
        try (Stream<Path> files = Files.list(searchDir);){
            folders = FastStream.of(files).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).toList();
        }
        catch (IOException ex) {
            LOGGER.warn("Failed to iterate directory.", (Throwable)ex);
            return null;
        }
        if (folders.size() != 1) {
            return null;
        }
        return this.tryFindInstallation((Path)folders.get(0));
    }

    @Nullable
    public Path findJdk(JavaVersion version, @Nullable String semver, boolean jre, boolean forceX64OnMac) {
        LOGGER.debug("Trying to find previously installed jvm matching Version: {} Semver: {} Jre: {} ForgeX64OnMac: {}", new Object[]{version, semver, jre, forceX64OnMac});
        OperatingSystem os = OperatingSystem.current();
        LinkedList candidates = FastStream.of(this.installations).filter(e -> version == JavaVersion.parse(e.version)).filter(e -> os != OperatingSystem.MACOS || forceX64OnMac == (e.architecture == Architecture.X64)).filter(e -> semver == null || semver.equals(e.version)).filter(e -> jre || e.isJdk).toLinkedList();
        if (candidates.isEmpty()) {
            LOGGER.debug(" Did not find a candidate.");
            return null;
        }
        LOGGER.debug(" Found {} candidates", (Object)candidates.size());
        candidates.forEach(e -> LOGGER.debug("  {}", e));
        candidates.sort(Comparator.comparing(e -> new ComparableVersion(e.version)).reversed());
        LOGGER.debug(" Sorted");
        candidates.forEach(e -> LOGGER.debug("  {}", e));
        Installation chosen = (Installation)candidates.getFirst();
        LOGGER.debug(" Chose {}", (Object)chosen);
        return JavaInstall.getHomeDirectory(((Installation)candidates.getFirst()).getPath(this.baseDir));
    }

    public Path provisionJdk(ProvisionRequest request) throws IOException {
        LOGGER.debug("Provision request: {}", (Object)request);
        Path existing = this.findJdk(request.version, request.semver, request.jre, request.forceX64OnMac);
        if (existing != null) {
            LOGGER.debug(" Filled request with existing jvm {}", (Object)existing);
            return existing;
        }
        LOGGER.debug("Did not find an existing jvm. Requesting a new one..");
        ProvisionResult result = this.provisioner.provisionJdk(this.baseDir, request);
        assert (Files.exists(result.baseDir, new LinkOption[0]));
        this.installations.add(new Installation(result.semver, result.isJdk, result.architecture, this.hashInstallation(result.baseDir), this.baseDir.relativize(result.baseDir).toString()));
        this.saveManifest();
        return JavaInstall.getHomeDirectory(result.baseDir);
    }

    private void saveManifest() {
        try {
            JsonUtils.write((Gson)GSON, (Path)IOUtils.makeParents((Path)this.manifestPath), this.installations, (Type)INSTALLS_TYPE, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            LOGGER.error("Failed to save JDKInstallation manifest!", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private String hashInstallation(Path installation) {
        try (Stream<Path> files = Files.walk(installation, new FileVisitOption[0]);){
            MessageDigest digest = Utils.getDigest("SHA-256");
            for (Path file : FastStream.of(files).sorted()) {
                if (!Files.isRegularFile(file, new LinkOption[0])) continue;
                Utils.addToDigest(digest, file);
            }
            String string = Utils.finishHash(digest);
            return string;
        }
        catch (IOException e) {
            LOGGER.error("Failed to hash java installation.", (Throwable)e);
            return null;
        }
    }

    private static /* synthetic */ boolean lambda$validateInstallationsDir$0(String rel, Installation e) {
        return e.path.equals(rel) || e.path.startsWith(rel + "/");
    }

    public static class Installation {
        public String version;
        public boolean isJdk;
        @Nullable
        public Architecture architecture;
        @Nullable
        public String hash;
        public String path;

        public Installation(String version, boolean isJdk, Architecture architecture, @Nullable String hash, String path) {
            this.version = version;
            this.isJdk = isJdk;
            this.architecture = architecture;
            this.hash = hash;
            this.path = path;
        }

        private static JsonElement migrate(JsonElement element) {
            if (!element.isJsonObject()) {
                return element;
            }
            JsonObject obj = element.getAsJsonObject();
            JsonArray array = new JsonArray();
            for (Map.Entry entry : obj.entrySet()) {
                if (!((JsonElement)entry.getValue()).isJsonObject()) continue;
                JsonObject entryObj = ((JsonElement)entry.getValue()).getAsJsonObject();
                entryObj.addProperty("isJdk", Boolean.valueOf(true));
                entryObj.addProperty("version", (String)entry.getKey());
                array.add((JsonElement)entryObj);
            }
            return array;
        }

        public boolean isExecutable(Path baseDir) {
            Path executable = JavaInstall.getJavaExecutable(JavaInstall.getHomeDirectory(this.getPath(baseDir)), true);
            return JavaInstall.parse(executable) != null;
        }

        public Path getPath(Path baseDir) {
            Path path = Paths.get(this.path, new String[0]);
            if (path.isAbsolute()) {
                return path;
            }
            return baseDir.resolve(path);
        }

        public String toString() {
            return new StringJoiner(", ", Installation.class.getSimpleName() + "[", "]").add("version='" + this.version + "'").add("isJdk=" + this.isJdk).add("architecture=" + this.architecture).add("hash='" + this.hash + "'").add("path='" + this.path + "'").toString();
        }
    }

    public static class ProvisionResult {
        public final String semver;
        public final Path baseDir;
        public final boolean isJdk;
        public final Architecture architecture;

        public ProvisionResult(String semver, Path baseDir, boolean isJdk, Architecture architecture) {
            this.semver = semver;
            this.baseDir = baseDir;
            this.isJdk = isJdk;
            this.architecture = architecture;
        }
    }

    public static class ProvisionRequest {
        public final JavaVersion version;
        @Nullable
        public final String semver;
        public final boolean jre;
        public final boolean forceX64OnMac;
        @Nullable
        public final RequestListener requestListener;

        public ProvisionRequest(Builder builder) {
            if (builder.version == null) {
                throw new IllegalStateException("Expected either a version, or semver filter");
            }
            this.version = builder.version;
            this.semver = builder.semver;
            this.jre = builder.jre;
            this.forceX64OnMac = builder.forceX64OnMac;
            this.requestListener = builder.requestListener;
        }

        public String toString() {
            return new StringJoiner(", ", ProvisionRequest.class.getSimpleName() + "[", "]").add("version=" + (Object)((Object)this.version)).add("semver='" + this.semver + "'").add("jre=" + this.jre).add("forceX64OnMac=" + this.forceX64OnMac).toString();
        }

        public static final class Builder {
            @Nullable
            private JavaVersion version;
            @Nullable
            private String semver;
            private boolean jre;
            private boolean forceX64OnMac;
            @Nullable
            private RequestListener requestListener;

            public Builder forVersion(JavaVersion version) {
                this.version = version;
                return this;
            }

            public Builder withSemver(String semver) {
                this.forVersion(Objects.requireNonNull(JavaVersion.parse(semver)));
                this.semver = semver;
                return this;
            }

            public Builder preferJRE(boolean jre) {
                this.jre = jre;
                return this;
            }

            public Builder forceX64OnMac(boolean forceX64OnMac) {
                this.forceX64OnMac = forceX64OnMac;
                return this;
            }

            public Builder downloadListener(RequestListener requestListener) {
                this.requestListener = requestListener;
                return this;
            }

            public ProvisionRequest build() {
                return new ProvisionRequest(this);
            }
        }
    }

    public static interface JdkProvisioner {
        public ProvisionResult provisionJdk(Path var1, ProvisionRequest var2) throws IOException;
    }
}

