/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.covers1624.coffeegrinder.bytecode.InvariantVisitor;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.transform.BlockTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.BlockTransformer;
import net.covers1624.coffeegrinder.bytecode.transform.StatementTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.StatementTransformer;

public class BlockStatementTransform
implements BlockTransformer {
    private final String name;
    private final List<StatementTransformer> transforms;

    private BlockStatementTransform(String name, List<StatementTransformer> transforms) {
        this.name = name;
        this.transforms = transforms;
    }

    public static BlockStatementTransform of(String name, StatementTransformer ... transforms) {
        return new BlockStatementTransform(name, (List<StatementTransformer>)ImmutableList.copyOf((Object[])transforms));
    }

    @Override
    public void transform(Block block, BlockTransformContext bCtx) {
        StatementTransformContext ctx = new StatementTransformContext(bCtx, block);
        block0: while (ctx.moveNext()) {
            for (StatementTransformer transform : this.transforms) {
                transform.transform(ctx.current(), ctx);
                InvariantVisitor.checkInvariants(ctx.current());
                if (!ctx.skipRequested) continue;
                ctx.skipRequested = false;
                continue block0;
            }
        }
        InvariantVisitor.checkInvariants(block);
    }

    @Override
    public String getName() {
        return this.name;
    }
}

