/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.util.asm;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Label;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;

public class LabelRange {
    public final Label start;
    public final Label end;
    public final List<Label> range;
    private final Set<Label> _range;

    public LabelRange(List<Label> range) {
        if (range.isEmpty()) {
            throw new IllegalArgumentException("Expected non empty range.");
        }
        this.start = range.get(0);
        this.end = range.get(range.size() - 1);
        this.range = ImmutableList.copyOf(range);
        this._range = ImmutableSet.copyOf(range);
    }

    public Label getStart() {
        return this.start;
    }

    public Label getEnd() {
        return this.end;
    }

    public List<Label> getRange() {
        return this.range;
    }

    public boolean containsLabel(Label label) {
        return this._range.contains(label);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LabelRange that = (LabelRange)o;
        return this._range.equals(that._range);
    }

    public int hashCode() {
        return this._range.hashCode();
    }

    public static LabelRange compute(InsnList list, Label start, Label end, boolean exclusiveEnd) {
        ArrayList<Label> labels = new ArrayList<Label>();
        for (AbstractInsnNode insnNode : list) {
            if (!(insnNode instanceof LabelNode)) continue;
            LabelNode labelNode = (LabelNode)insnNode;
            Label label = labelNode.getLabel();
            if (labels.isEmpty() && label != start) continue;
            labels.add(label);
            if (label != end) continue;
            if (!exclusiveEnd) break;
            labels.remove(label);
            break;
        }
        if (labels.isEmpty()) {
            throw new IllegalStateException("Unable to find start label.");
        }
        if (!exclusiveEnd && !labels.contains(end)) {
            throw new IllegalStateException("Unable to find end label.");
        }
        return new LabelRange(labels);
    }

    public static Label getLabelAfter(InsnList list, Label target) {
        boolean foundLabel = false;
        for (AbstractInsnNode insnNode : list) {
            if (!(insnNode instanceof LabelNode)) continue;
            LabelNode labelNode = (LabelNode)insnNode;
            Label label = labelNode.getLabel();
            if (label == target) {
                foundLabel = true;
                continue;
            }
            if (!foundLabel) continue;
            return label;
        }
        throw new IllegalStateException("Unable to find next label.");
    }

    @Nullable
    public static LabelRange extractRange(InsnList list) {
        ArrayList<Label> labels = new ArrayList<Label>();
        for (AbstractInsnNode insnNode : list) {
            if (!(insnNode instanceof LabelNode)) continue;
            labels.add(((LabelNode)insnNode).getLabel());
        }
        if (labels.isEmpty()) {
            return null;
        }
        return new LabelRange(labels);
    }
}

