/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.insns;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionCollection;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.bytecode.insns.Branch;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.util.EnumBitSet;
import net.covers1624.quack.collection.FastStream;
import org.jetbrains.annotations.Nullable;

public class Block
extends Instruction {
    public final InstructionCollection<Instruction> instructions = new InstructionCollection(this);
    private boolean isEntryPoint;
    private final List<Branch> branches = new LinkedList<Branch>();
    @Nullable
    private String name;

    public Block() {
        this(null, false);
    }

    public Block(String name) {
        this(name, false);
    }

    private Block(@Nullable String name, boolean unused) {
        super(InsnOpcode.BLOCK);
        this.name = name;
    }

    @Override
    public AType getResultType() {
        return PrimitiveType.VOID;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.NONE;
    }

    @Override
    public Block copy() {
        Block block = new Block();
        block.instructions.addAll((Iterable<Instruction>)this.instructions.map(Instruction::copy));
        return block;
    }

    @Override
    protected void onConnected() {
        super.onConnected();
        if (this.name == null) {
            this.name = ((MethodDecl)this.firstAncestorOfType(InsnOpcode.METHOD_DECL)).getSynBlockName(this);
        }
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitBlock(this, ctx);
    }

    public Block extractRange(Instruction first, Instruction last) {
        return this.extractRange(null, first, last);
    }

    public Block extractRange(@Nullable String subName, Instruction first, Instruction last) {
        assert (first.getParent() == this);
        assert (last.getParent() == this);
        Block newBlock = new Block();
        if (subName != null) {
            newBlock.setName(this.getSubName(subName));
        }
        newBlock.setOffsets(first);
        Instruction pointer = first;
        while (true) {
            Instruction next = pointer.getNextSiblingOrNull();
            newBlock.instructions.add(pointer);
            if (pointer == last) break;
            assert (next != null);
            pointer = next;
        }
        return newBlock;
    }

    void addBranch(Branch branch) {
        this.branches.add(branch);
    }

    void remBranch(Branch branch) {
        this.branches.remove(branch);
    }

    public FastStream<Branch> getBranches() {
        return FastStream.of(this.branches);
    }

    void setEntryPoint(boolean isEntryPoint) {
        this.isEntryPoint = isEntryPoint;
    }

    public int getIncomingEdgeCount() {
        return this.branches.size() + (this.isEntryPoint ? 1 : 0);
    }

    public String getName() {
        return Objects.requireNonNull(this.name);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSubName(String nameSuffix) {
        return this.getName() + "_" + nameSuffix;
    }
}

