/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.insns;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionCollection;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.bytecode.insns.FieldDecl;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.AnnotationData;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.Field;
import net.covers1624.coffeegrinder.type.Method;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.type.TypeAnnotationData;
import net.covers1624.coffeegrinder.util.EnumBitSet;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.util.SneakyUtils;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

public class ClassDecl
extends Instruction {
    private ClassType clazz;
    public final InstructionCollection<Instruction> members = new InstructionCollection(this);
    public final List<RecordComponentDecl> recordComponents = new ArrayList<RecordComponentDecl>();
    @Nullable
    public MethodDecl canonicalCtor;
    @Nullable
    private Map<Method, MethodDecl> methodLookup;
    @Nullable
    private List<ClassDecl> nestedClasses;

    public ClassDecl(ClassType clazz) {
        super(InsnOpcode.CLASS_DECL);
        this.clazz = clazz;
    }

    @Override
    public AType getResultType() {
        return PrimitiveType.VOID;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.NONE;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitClassDecl(this, ctx);
    }

    public ClassType getClazz() {
        return this.clazz;
    }

    public FastStream<FieldDecl> getFieldMembers() {
        return (FastStream)SneakyUtils.unsafeCast((Object)this.members.filter(e -> e.opcode == InsnOpcode.FIELD_DECL));
    }

    public FastStream<MethodDecl> getMethodMembers() {
        return (FastStream)SneakyUtils.unsafeCast((Object)this.members.filter(e -> e.opcode == InsnOpcode.METHOD_DECL));
    }

    public FastStream<ClassDecl> getClassMembers() {
        return (FastStream)SneakyUtils.unsafeCast((Object)this.members.filter(e -> e.opcode == InsnOpcode.CLASS_DECL));
    }

    public void setClazz(ClassType clazz) {
        this.clazz = clazz;
    }

    @Nullable
    public FieldDecl findField(String name, Type desc) {
        return (FieldDecl)this.getFieldMembers().filter(e -> e.getField().getName().equals(name) && e.getField().getDescriptor().equals((Object)desc)).onlyOrDefault();
    }

    @Nullable
    public FieldDecl findField(Field field) {
        return (FieldDecl)this.getFieldMembers().filter(e -> e.getField() == field).onlyOrDefault();
    }

    public FieldDecl getField(String name, Type desc) {
        return Objects.requireNonNull(this.findField(name, desc));
    }

    public void onParsed() {
        if (this.methodLookup != null) {
            throw new IllegalStateException("Internal method.");
        }
        this.methodLookup = this.getMethodMembers().toImmutableMap(MethodDecl::getMethod, Function.identity());
        this.nestedClasses = this.getClassMembers().toImmutableList();
    }

    public List<ClassDecl> getNestedClasses() {
        return Objects.requireNonNull(this.nestedClasses, "Only available after methods have finished being parsed.");
    }

    public Map<Method, MethodDecl> getMethodLookup() {
        return Objects.requireNonNull(this.methodLookup, "Only available after methods have finished being parsed.");
    }

    @Nullable
    public MethodDecl findMethod(String name, Type desc) {
        return (MethodDecl)FastStream.of(this.getMethodLookup().values()).filter(e -> e.getMethod().getName().equals(name) && e.getMethod().getDescriptor().equals((Object)desc)).onlyOrDefault();
    }

    @Nullable
    public MethodDecl findMethod(Method method) {
        return this.getMethodLookup().get(method);
    }

    public MethodDecl getMethod(String name, Type desc) {
        return Objects.requireNonNull(this.findMethod(name, desc));
    }

    public MethodDecl getMethod(Method method) {
        return Objects.requireNonNull(this.findMethod(method));
    }

    public static class RecordComponentDecl {
        public final FieldDecl field;
        public final boolean isVarargs;
        @Nullable
        public MethodDecl accessor;
        public final TypeAnnotationData typeAnnotations;
        public final List<AnnotationData> regularAnnotations;

        public RecordComponentDecl(FieldDecl field, boolean isVarargs, MethodDecl accessor, TypeAnnotationData typeAnnotations, List<AnnotationData> regularAnnotations) {
            this.field = field;
            this.isVarargs = isVarargs;
            this.accessor = accessor;
            this.typeAnnotations = typeAnnotations;
            this.regularAnnotations = regularAnnotations;
        }
    }
}

