package net.covers1624.coffeegrinder.bytecode;

/**
 * Created by covers1624 on 5/7/21.
 */
public class DebugPrintOptions {

    public static final boolean PRINT_LINE_NUMBERS_DEFAULT = false;
    public static final boolean PRINT_BYTECODE_RANGES_DEFAULT = false;
    public static final boolean PRINT_TAGS_DEFAULT = false;
    public static final boolean SHOW_IMPLICITS_DEFAULT = false;
    public static final boolean QUALIFIED_MEMBER_REFERENCES_DEFAULT = false;
    public static final boolean HIDE_LOADS_DEFAULT = false;
    public static final boolean TREE_VIEW_DEFAULT = false;

    public static final DebugPrintOptions DEFAULT = new DebugPrintOptions(
            PRINT_LINE_NUMBERS_DEFAULT,
            PRINT_BYTECODE_RANGES_DEFAULT,
            PRINT_TAGS_DEFAULT,
            SHOW_IMPLICITS_DEFAULT,
            QUALIFIED_MEMBER_REFERENCES_DEFAULT,
            HIDE_LOADS_DEFAULT,
            TREE_VIEW_DEFAULT
    );

    public final boolean printLineNumbers;
    public final boolean printRanges;
    public final boolean printTags;
    public final boolean showImplicits;
    public final boolean qualifiedMemberReferences;
    public final boolean hideLoads;
    public final boolean treeView;

    public DebugPrintOptions(
            boolean printLineNumbers,
            boolean printRanges,
            boolean printTags,
            boolean showImplicits,
            boolean qualifiedMemberReferences,
            boolean hideLoads,
            boolean treeView) {
        this.printLineNumbers = printLineNumbers;
        this.printRanges = printRanges;
        this.printTags = printTags;
        this.showImplicits = showImplicits;
        this.qualifiedMemberReferences = qualifiedMemberReferences;
        this.hideLoads = hideLoads;
        this.treeView = treeView;
    }
}
