package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.*;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.util.EnumBitSet;

/**
 * Created by covers1624 on 9/9/21.
 */
public class CompoundAssignment extends Instruction {

    private final BinaryOp op;
    private final InstructionSlot<Reference> reference = new InstructionSlot<>(this);
    private final InstructionSlot<Instruction> value = new InstructionSlot<>(this);

    public CompoundAssignment(BinaryOp op, Reference reference, Instruction value) {
        super(InsnOpcode.COMPOUND_ASSIGNMENT);
        this.op = op;
        this.reference.set(reference);
        this.value.set(value);
    }

    @Override
    public AType getResultType() {
        return getReference().getType();
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        AType result = getResultType();
        // Integers are special and numeric operations throw exceptions in some cases.
        boolean doesThrow = (result == PrimitiveType.INT || result == PrimitiveType.LONG) && (op == BinaryOp.DIV || op == BinaryOp.REM);
        return doesThrow ? InstructionFlag.MAY_THROW.toSet() : InstructionFlag.NONE;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitCompoundAssignment(this, ctx);
    }

    @Override
    protected void onChildModified() {
        super.onChildModified();
        if (isConnected()) {
            getReference().setReadFrom(true);
            getReference().setWrittenTo(true);
        }
    }

    @Override
    protected void onConnected() {
        super.onConnected();
        getReference().setReadFrom(true);
        getReference().setWrittenTo(true);
    }

    //@formatter:off
    public Reference getReference() { return reference.get(); }
    public Instruction getValue() { return value.get(); }
    public BinaryOp getOp() { return op; }
    //@formatter:on
}
