package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;

/**
 * Created by covers1624 on 13/4/21.
 */
public class InstanceOf extends Unary {

    private AType type;

    public InstanceOf(Instruction argument, AType type) {
        super(InsnOpcode.INSTANCE_OF, argument);
        this.type = type;
    }

    @Override
    public AType getResultType() {
        return PrimitiveType.BOOLEAN;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitInstanceOf(this, ctx);
    }

    //@formatter:off
    public AType getType() { return type; }
    public void setType(AType type) { this.type = type; }
    //@formatter:on
}
