package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.*;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.type.ReferenceType;
import net.covers1624.coffeegrinder.type.TypeSystem;
import net.covers1624.coffeegrinder.util.EnumBitSet;

/**
 * Created by covers1624 on 18/12/21.
 */
public class Ternary extends Instruction {

    private final InstructionSlot<Instruction> condition = new InstructionSlot<>(this);
    private final InstructionSlot<Instruction> trueInsn = new InstructionSlot<>(this);
    private final InstructionSlot<Instruction> falseInsn = new InstructionSlot<>(this);

    public Ternary(Instruction condition, Instruction trueInsn, Instruction falseInsn) {
        super(InsnOpcode.TERNARY);
        this.condition.set(condition);
        this.trueInsn.set(trueInsn);
        this.falseInsn.set(falseInsn);
    }

    @Override
    public AType getResultType() {
        return getResultType(getTrueInsn().getResultType(), getFalseInsn().getResultType());
    }

    private static AType getResultType(AType a, AType b) {
        if (TypeSystem.isAssignableTo(a, b)) return b;
        if (TypeSystem.isAssignableTo(b, a)) return a;

        if (a instanceof ReferenceType) {
            return TypeSystem.lub((ReferenceType) a, (ReferenceType) b);
        }

        return PrimitiveType.INT; // the 'constantness' and assignability of the integer constants are lost when doing a ternary in Java for whatever reason.
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.NONE;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitTernary(this, ctx);
    }

    //@formatter:off
    public Instruction getCondition() { return condition.get(); }
    public Instruction getTrueInsn() { return trueInsn.get(); }
    public Instruction getFalseInsn() { return falseInsn.get(); }
    //@formatter:on
}
