package net.covers1624.coffeegrinder.type;

import com.google.common.collect.ImmutableMap;

import java.util.List;
import java.util.Map;

/**
 * Created by covers1624 on 12/9/22.
 */
public class AnnotationData {

    /**
     * The Annotation class these values belong to.
     */
    public final ClassType type;

    /**
     * Contains a map of {@link String} to annotation field value.
     * <p>
     * A value may be one of {@link Byte}, {@link Boolean}, {@link Character},
     * {@link Short}, {@link Integer}, {@link Long}, {@link Float}, {@link Double},
     * {@link String}, {@link Boolean}, {@link ClassType}, {@link Field} for enum constants,
     * {@link AnnotationData} for another annotation, or a {@link List} of one of the prior mentioned types, boxed.
     */
    public final Map<String, Object> values;

    public AnnotationData(ClassType type, Map<String, Object> values) {
        this.type = type;
        this.values = ImmutableMap.copyOf(values);
    }

    public boolean isEmpty() {
        return values.isEmpty();
    }

    public boolean isSingleElement() {
        return values.size() == 1 && values.containsKey("value");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AnnotationData that = (AnnotationData) o;

        if (!type.equals(that.type)) return false;
        return values.equals(that.values);
    }
}
