package net.covers1624.coffeegrinder.type;

import com.google.common.collect.ImmutableList;
import net.covers1624.coffeegrinder.bytecode.AccessFlag;
import net.covers1624.coffeegrinder.util.EnumBitSet;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

import java.util.List;

/**
 * Created by covers1624 on 20/9/22.
 */
public class PolymorphicSignatureMethod extends Method {

    private final Method decl;
    private final Type desc;

    private final AType returnType;
    private final List<Parameter> parameters;

    public PolymorphicSignatureMethod(Method decl, TypeResolver typeResolver, Type desc) {
        this.decl = decl;
        this.desc = desc;

        // Result is always Object, requires a cast to be inserted.
        returnType = typeResolver.resolveType(TypeResolver.OBJECT_TYPE);

        ImmutableList.Builder<Parameter> builder = ImmutableList.builder();
        int i = 0;
        for (Type arg : desc.getArgumentTypes()) {
            builder.add(new Parameter(
                    "p_" + i++,
                    this,
                    typeResolver.resolveType(arg),
                    EnumBitSet.noneOf(AccessFlag.class)
            ));
        }
        parameters = builder.build();
    }

    // @formatter:off
    @Override public List<TypeParameter> getTypeParameters() { return ImmutableList.of(); }
    @Override public ClassType getDeclaringClass() { return decl.getDeclaringClass(); }
    @Override public String getName() { return decl.getName(); }
    @Override public AType getReturnType() { return returnType; }
    @Override public List<Parameter> getParameters() { return parameters; }
    @Override public List<ReferenceType> getExceptions() { return decl.getExceptions(); }
    @Override public EnumBitSet<AccessFlag> getAccessFlags() { return decl.getAccessFlags(); }
    @Override public Type getDescriptor() { return desc; }
    @Override public AnnotationSupplier getAnnotationSupplier() { return decl.getAnnotationSupplier(); }
    @Override @Nullable public Object getDefaultAnnotationValue() { return null; }
    @Override public Method getDeclaration() { return this; }
    @Override public Method asRaw() { return this; }
    @Override public boolean isConstructor() { return false; }
    // @formatter:on
}
