/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.testengine.javac;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.covers1624.coffeegrinder.testengine.common.BaseExecutionContext;
import net.covers1624.coffeegrinder.testengine.common.BaseTestEngine;
import net.covers1624.coffeegrinder.testengine.javac.MainJavacContext;
import net.covers1624.coffeegrinder.testengine.javac.node.CompileNode;
import net.covers1624.coffeegrinder.testengine.javac.node.DecompileClassesNode;
import net.covers1624.coffeegrinder.testengine.javac.node.JavacTestCaseDescriptor;
import net.covers1624.quack.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;

public class JavacTestCaseEngine
extends BaseTestEngine<BaseExecutionContext> {
    private static final Pattern COMPILE = Pattern.compile("^[ *]* @compile ((?: ?[\\w/]*.java)+)$", 8);
    private static final Logger LOGGER = LogManager.getLogger();

    public JavacTestCaseEngine() {
        super("javac-engine", "coffeegrinder.javactests");
    }

    @Override
    protected BaseExecutionContext createExecutionContextImpl(ExecutionRequest request) {
        return new MainJavacContext(request.getConfigurationParameters());
    }

    @Override
    protected TestDescriptor discoverImpl(EngineDiscoveryRequest discoveryRequest, UniqueId uniqueId) {
        EngineDescriptor rootDescriptor = new EngineDescriptor(uniqueId, "CoffeeGrinder Javac Cases");
        Path rootDir = (Path)discoveryRequest.getConfigurationParameters().get("coffeegrinder.test.root", x$0 -> Paths.get(x$0, new String[0])).orElseThrow(() -> new IllegalStateException("Missing required configuration option 'coffeegrinder.test.root'."));
        for (Pair<Path, List<String>> testCase : JavacTestCaseEngine.locateTestCases(rootDir)) {
            String name = ((Path)testCase.getLeft()).getFileName().toString().replace(".java", "");
            JavacTestCaseDescriptor desc = new JavacTestCaseDescriptor(rootDescriptor.getUniqueId(), name, ((Path)testCase.getLeft()).getParent(), (List)testCase.getRight());
            desc.addChild((TestDescriptor)new CompileNode(desc.getUniqueId(), "InitialCompile", CompileNode.CompileType.INITIAL));
            desc.addChild((TestDescriptor)new DecompileClassesNode(desc.getUniqueId()));
            desc.addChild((TestDescriptor)new CompileNode(desc.getUniqueId(), "Recompile", CompileNode.CompileType.RECOMP));
            rootDescriptor.addChild((TestDescriptor)desc);
        }
        return rootDescriptor;
    }

    private static List<Pair<Path, List<String>>> locateTestCases(Path directory) {
        try {
            List files;
            Stream<Path> dirStream = Files.walk(directory, new FileVisitOption[0]);
            Object object = null;
            try {
                files = dirStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(e -> e.getFileName().toString().endsWith(".java")).filter(e -> Files.notExists(e.getParent().resolve(e.getFileName().toString().replace(".java", ".out")), new LinkOption[0])).sorted().collect(Collectors.toList());
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (dirStream != null) {
                    if (object != null) {
                        try {
                            dirStream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        dirStream.close();
                    }
                }
            }
            LinkedList<Pair<Path, List<String>>> testFiles = new LinkedList<Pair<Path, List<String>>>();
            for (Path file : files) {
                LOGGER.info((Object)file);
                String content = IOUtils.readAll((Path)file);
                Matcher matcher = COMPILE.matcher(content);
                while (matcher.find()) {
                    LOGGER.info(" " + matcher.group(1));
                    testFiles.add((Pair<Path, List<String>>)Pair.of((Object)file, (Object)ImmutableList.copyOf((Object[])matcher.group(1).split(" "))));
                }
            }
            return testFiles;
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to iterate files.", ex);
        }
    }
}

