/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.util.resolver;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.covers1624.coffeegrinder.util.resolver.FolderResolver;
import net.covers1624.coffeegrinder.util.resolver.JModResolver;
import net.covers1624.coffeegrinder.util.resolver.JarResolver;
import net.covers1624.quack.collection.FastStream;
import org.jetbrains.annotations.Nullable;

public interface Resolver
extends Closeable {
    public FastStream<String> getAllClasses() throws IOException;

    public FastStream<String> getAllResources() throws IOException;

    default public byte @Nullable [] getClassBytes(String name) throws IOException {
        return this.getResource(name.replace(".", "/") + ".class");
    }

    default public boolean hasClass(String name) {
        return this.hasResource(name.replace('.', '/') + ".class");
    }

    public byte @Nullable [] getResource(String var1) throws IOException;

    public boolean hasResource(String var1);

    @Override
    default public void close() throws IOException {
    }

    public static Resolver findResolver(Path path) {
        if (Files.notExists(path, new LinkOption[0])) {
            throw new RuntimeException("Provided path does not exist. Can't create resolver." + path);
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            return new FolderResolver(path);
        }
        String fName = path.getFileName().toString();
        if (fName.endsWith(".jar") || fName.endsWith(".zip")) {
            return new JarResolver(path);
        }
        if (fName.endsWith(".jmod")) {
            return new JModResolver(path);
        }
        throw new IllegalArgumentException("Unable to find Resolver for type. " + path);
    }
}

