/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform;

import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.bytecode.SimpleInsnVisitor;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.insns.BlockContainer;
import net.covers1624.coffeegrinder.bytecode.insns.Continue;
import net.covers1624.coffeegrinder.bytecode.insns.Leave;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.bytecode.insns.TryCatch;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformer;
import net.covers1624.coffeegrinder.util.None;
import org.jetbrains.annotations.Nullable;

public class ExitPointCleanup
extends SimpleInsnVisitor<MethodTransformContext>
implements MethodTransformer {
    @Override
    public void transform(MethodDecl function, MethodTransformContext ctx) {
        function.accept(this, ctx);
    }

    @Override
    public None visitBlock(Block block, MethodTransformContext ctx) {
        this.unwrapLeaveToContinueIn(block, ctx);
        return (None)super.visitBlock(block, ctx);
    }

    @Override
    public None visitTryCatch(TryCatch tryCatch, MethodTransformContext ctx) {
        super.visitTryCatch(tryCatch, ctx);
        this.cleanupOrphanedExitAfterCatchFixups(tryCatch, ctx);
        return NONE;
    }

    private void unwrapLeaveToContinueIn(Block block, MethodTransformContext ctx) {
        Instruction insn = block.instructions.secondToLastOrDefault();
        if (insn == null || insn.opcode != InsnOpcode.BLOCK_CONTAINER) {
            return;
        }
        this.unwrapLeaveToContinue((BlockContainer)insn, ctx);
    }

    private void unwrapLeaveToContinue(BlockContainer container, MethodTransformContext ctx) {
        if (container.blocks.size() > 1) {
            return;
        }
        Block parent = (Block)container.getParent();
        Instruction exit = container.getNextSibling();
        Continue cont = this.matchContinueOrLeaveToContinue(exit);
        if (cont == null) {
            return;
        }
        ctx.pushStep("Unwrap container with break to continue");
        for (Leave e : container.getLeaves().toList()) {
            e.replaceWith(new Continue(cont.getLoop()).withOffsets(e));
        }
        exit.remove();
        Block b = (Block)container.getFirstChild();
        parent.instructions.addAll((Iterable<Instruction>)((Object)b.instructions));
        container.remove();
        ctx.popStep();
    }

    @Nullable
    private Continue matchContinueOrLeaveToContinue(Instruction insn) {
        if (insn.opcode == InsnOpcode.CONTINUE) {
            return (Continue)insn;
        }
        if (insn.opcode == InsnOpcode.LEAVE) {
            return this.followFlowToContinue((Leave)insn);
        }
        return null;
    }

    private void cleanupOrphanedExitAfterCatchFixups(TryCatch tryCatch, MethodTransformContext ctx) {
        if (tryCatch.getParent().opcode != InsnOpcode.BLOCK) {
            return;
        }
        Instruction next = tryCatch.getNextSiblingOrNull();
        if (!tryCatch.hasFlag(InstructionFlag.END_POINT_UNREACHABLE) || next == null) {
            return;
        }
        assert (next.hasFlag(InstructionFlag.END_POINT_UNREACHABLE));
        ctx.pushStep("Remove unreachable fallthrough");
        next.remove();
        ctx.popStep();
    }

    @Nullable
    private Continue followFlowToContinue(Leave leave) {
        if (leave.getTargetContainer().getParent().opcode != InsnOpcode.TRY_CATCH_HANDLER) {
            return null;
        }
        Instruction next = leave.getTargetContainer().getParent().getParent().getNextSibling();
        if (next.opcode == InsnOpcode.CONTINUE) {
            return (Continue)next;
        }
        if (next.opcode != InsnOpcode.LEAVE) {
            return null;
        }
        return this.followFlowToContinue((Leave)next);
    }
}

