/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.type;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.ReferenceType;
import net.covers1624.coffeegrinder.type.TypeSystem;
import net.covers1624.quack.collection.ColUtils;
import net.covers1624.quack.collection.FastStream;
import org.jetbrains.annotations.Nullable;

public class IntersectionType
extends ReferenceType {
    @Nullable
    public final ReferenceType baseType;
    private final List<ClassType> interfaces;

    public IntersectionType(@Nullable ReferenceType baseType, List<ClassType> interfaces) {
        assert (baseType == null || !TypeSystem.isInterface(baseType));
        assert (baseType != null || interfaces.size() > 1);
        assert (!(baseType instanceof IntersectionType));
        assert (!interfaces.isEmpty());
        assert (ColUtils.allMatch(interfaces, TypeSystem::isInterface));
        assert (FastStream.of(interfaces).map(ClassType::getDeclaration).distinct().count() == interfaces.size());
        this.baseType = baseType;
        this.interfaces = ImmutableList.copyOf(interfaces);
    }

    @Override
    public String getName() {
        return this.getDirectSuperTypes().map(AType::getName).join(" & ");
    }

    @Override
    public String getFullName() {
        return this.getDirectSuperTypes().map(AType::getFullName).join(" & ");
    }

    public String toString() {
        return this.getFullName();
    }

    @Override
    public ReferenceType getSuperType() {
        return this.baseType != null ? this.baseType : (ReferenceType)this.interfaces.get(0);
    }

    public List<ClassType> getInterfaces() {
        return this.interfaces;
    }

    public FastStream<ReferenceType> getDirectSuperTypes() {
        FastStream types = FastStream.of(this.interfaces);
        if (this.baseType != null) {
            types = FastStream.of((Object)this.baseType).concat((Iterable)types);
        }
        return types;
    }

    @Override
    public boolean mentions(ReferenceType type) {
        return super.mentions(type) || this.getDirectSuperTypes().anyMatch(e -> e.mentions(type));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IntersectionType)) {
            return false;
        }
        IntersectionType other = (IntersectionType)o;
        if (!Objects.equals(this.baseType, other.baseType)) {
            return false;
        }
        return this.interfaces.equals(other.interfaces);
    }

    public int hashCode() {
        int result = this.baseType != null ? this.baseType.hashCode() : 0;
        result = 31 * result + this.interfaces.hashCode();
        return result;
    }
}

