/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.jdkutils.utils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Objects;
import java.util.zip.GZIPInputStream;
import net.covers1624.quack.io.IOUtils;
import net.covers1624.quack.platform.OperatingSystem;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiStatus.Internal
public class ArchiveUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArchiveUtils.class);

    public static Path extractArchive(Path baseDir, Path archive) throws IOException {
        Path extractionDir = baseDir.resolve(ArchiveUtils.getNameWithoutExtension(archive.getFileName()));
        LOGGER.debug("Extracting archive {} into {}", (Object)archive, (Object)extractionDir);
        Path basePath = null;
        try (ArchiveInputStream<?> is = ArchiveUtils.open(archive);){
            ArchiveEntry entry;
            while ((entry = is.getNextEntry()) != null) {
                Path file = entry.resolveIn(extractionDir);
                if (entry.isDirectory()) {
                    if (basePath == null) {
                        basePath = file;
                    }
                    Files.createDirectories(file, new FileAttribute[0]);
                } else {
                    Files.copy(is, IOUtils.makeParents((Path)file), new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                }
                ArchiveUtils.writeAttributes(file, entry);
            }
        }
        LOGGER.debug("Extracted. Base dir {}", (Object)baseDir);
        return Objects.requireNonNull(basePath, "Base path was not set during extraction. Empty zip? Archive with no files?");
    }

    private static void writeAttributes(Path file, ArchiveEntry entry) throws IOException {
        Files.setLastModifiedTime(file, FileTime.fromMillis(entry.getLastModifiedDate().getTime()));
        if (OperatingSystem.current().isUnixLike() && entry instanceof TarArchiveEntry) {
            Files.setPosixFilePermissions(file, IOUtils.parseMode((int)ArchiveUtils.fixMode(((TarArchiveEntry)entry).getMode())));
        }
    }

    private static int fixMode(int mode) {
        if (mode == 16877 || mode == 33188) {
            return mode;
        }
        return Integer.parseInt(Integer.toOctalString(mode));
    }

    private static String getNameWithoutExtension(Path file) {
        return file.toString().replace(".zip", "").replace(".tar.gz", "");
    }

    private static ArchiveInputStream<?> open(Path archive) throws IOException {
        String fName = archive.getFileName().toString();
        if (fName.endsWith(".zip")) {
            return new ZipArchiveInputStream(Files.newInputStream(archive, new OpenOption[0]));
        }
        if (fName.endsWith(".tar.gz")) {
            return new TarArchiveInputStream((InputStream)new GZIPInputStream(Files.newInputStream(archive, new OpenOption[0])));
        }
        throw new UnsupportedOperationException("Unable to extract archive. Unhandled file format: " + fName);
    }
}

