package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.quack.collection.FastStream;

import java.util.LinkedList;
import java.util.List;

/**
 * Created by covers1624 on 12/9/21.
 */
public abstract class AbstractLoop extends Instruction {

    private final List<Continue> continues = new LinkedList<>();

    protected AbstractLoop(InsnOpcode opcode) {
        super(opcode);
    }

    void addContinue(Continue cont) {
        assert cont.getLoop() == this;
        assert !continues.contains(cont);
        continues.add(cont);
    }

    void remContinue(Continue cont) {
        assert cont.getLoop() == this;
        assert continues.contains(cont);
        continues.remove(cont);
    }

    public FastStream<Continue> getContinues() {
        return FastStream.of(continues);
    }

    public abstract BlockContainer getBody();
}
