package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.*;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.util.EnumBitSet;

/**
 * Created by covers1624 on 4/4/21.
 */
public class Comparison extends Instruction {

    private ComparisonKind kind;
    private final InstructionSlot<Instruction> left = new InstructionSlot<>(this);
    private final InstructionSlot<Instruction> right = new InstructionSlot<>(this);

    public Comparison(ComparisonKind kind, Instruction left, Instruction right) {
        super(InsnOpcode.COMPARISON);
        this.kind = kind;
        this.left.set(left);
        this.right.set(right);
    }

    @Override
    public AType getResultType() {
        return PrimitiveType.BOOLEAN;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.NONE;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitComparison(this, ctx);
    }

    //@formatter:off
    public ComparisonKind getKind() { return kind; }
    public Instruction getLeft() { return left.get(); }
    public Instruction getRight() { return right.get(); }
    public void setKind(ComparisonKind kind) { this.kind = kind; }
    public void setLeft(Instruction left) { this.left.set(left); }
    public void setRight(Instruction right) { this.right.set(right); }
    //@formatter:on

    public enum ComparisonKind {
        EQUAL("=="),
        NOT_EQUAL("!="),
        GREATER_THAN(">"),
        GREATER_THAN_EQUAL(">="),
        LESS_THAN("<"),
        LESS_THAN_EQUAL("<=");

        public final String chars;

        ComparisonKind(String chars) {
            this.chars = chars;
        }

        /**
         * Computes the negation of the current {@link ComparisonKind}.
         * <code>
         * EQUAL              -> NOT_EQUAL
         * NOT_EQUAL          -> EQUAL
         * GREATER_THAN       -> LESS_THAN_EQUAL
         * GREATER_THAN_EQUAL -> LESS_THAN
         * LESS_THAN          -> GREATER_THAN_EQUAL
         * LESS_THAN_EQUAL    -> GREATER_THAN
         * </code>
         *
         * @return The negated value.
         */
        public ComparisonKind negate() {
            switch (this) {
                case EQUAL:
                    return NOT_EQUAL;
                case NOT_EQUAL:
                    return EQUAL;
                case GREATER_THAN:
                    return LESS_THAN_EQUAL;
                case GREATER_THAN_EQUAL:
                    return LESS_THAN;
                case LESS_THAN:
                    return GREATER_THAN_EQUAL;
                case LESS_THAN_EQUAL:
                    return GREATER_THAN;
                default:
                    throw new AssertionError("Switch falloff.");
            }
        }
    }
}
