package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.InstructionSlot;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.TypeSystem;
import org.jetbrains.annotations.Nullable;

import static java.util.Objects.requireNonNull;
import static net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching.matchLocalRef;

/**
 * Created by covers1624 on 28/2/21.
 */
public class Load extends SimpleInstruction {

    private final InstructionSlot<Reference> reference = new InstructionSlot<>(this);

    @Nullable
    private AType cachedReferenceType;
    @Nullable
    private AType resultType;

    public Load(Reference reference) {
        super(InsnOpcode.LOAD);
        this.reference.set(reference);
    }

    @Override
    public AType getResultType() {
        AType type = getReference().getType();
        if (!type.equals(cachedReferenceType)) {
            cachedReferenceType = type;
            resultType = TypeSystem.capture(cachedReferenceType);
        }

        assert resultType != null;
        return resultType;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitLoad(this, ctx);
    }

    @Override
    public Load copy() {
        return new Load(getReference().copy());
    }

    public Reference getReference() {
        return reference.get();
    }

    @Override
    protected void onChildModified() {
        super.onChildModified();
        if (isConnected()) {
            getReference().setReadFrom(true);
        }
    }

    @Override
    protected void onConnected() {
        super.onConnected();
        getReference().setReadFrom(true);
    }

    public LocalVariable getVariable() {
        return requireNonNull(matchLocalRef(getReference()), "Not a LocalReference").variable;
    }
}
