package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;

/**
 * Created by covers1624 on 6/7/21.
 */
public class Monitor extends Unary {

    protected Monitor(InsnOpcode kind, Instruction argument) {
        super(kind, argument);
    }

    @Override
    public AType getResultType() {
        return PrimitiveType.VOID;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitMonitor(this, ctx);
    }

    public static Monitor monitorEnter(Instruction arg) {
        return new Monitor(InsnOpcode.MONITOR_ENTER, arg);
    }

    public static Monitor monitorExit(Instruction arg) {
        return new Monitor(InsnOpcode.MONITOR_EXIT, arg);
    }
}
