package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.*;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.Method;
import net.covers1624.coffeegrinder.type.TypeSystem;
import net.covers1624.coffeegrinder.util.EnumBitSet;
import org.jetbrains.annotations.Nullable;

/**
 * Created by covers1624 on 15/4/21.
 */
public class New extends AbstractInvoke {

    private ClassType type;
    private Method ctor;
    public boolean explicitClassTypeArgs;
    public boolean hasEnclosingScopeInstanceParam;

    private final IndexedInstructionCollection<Instruction> arguments;

    private final InstructionSlot<Instruction> anonymousClassDeclaration = new InstructionSlot<>(this);

    public New(ClassType type, Method ctor, Iterable<Instruction> args) {
        this(type, ctor, args, new Nop());
    }

    private New(ClassType type, Method ctor, Iterable<Instruction> args, Instruction anonClassDeclaration) {
        super(InsnOpcode.NEW);
        this.type = type;
        this.ctor = ctor;

        arguments = new IndexedInstructionCollection<>(this);
        arguments.setValues(args);
        anonymousClassDeclaration.set(anonClassDeclaration);

        assert type.getDeclaration() == ctor.getDeclaringClass();
    }

    @Override
    public ClassType getResultType() {
        return type;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.MAY_THROW.toSet();
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitNew(this, ctx);
    }

    public void setAnonymousClassDeclaration(ClassDecl anonymousClassDeclaration) {
        this.anonymousClassDeclaration.set(anonymousClassDeclaration);
    }

    public boolean hasAnonymousClassDeclaration() {
        return anonymousClassDeclaration.get().opcode == InsnOpcode.CLASS_DECL;
    }

    public ClassDecl getAnonymousClassDeclaration() {
        assert hasAnonymousClassDeclaration();
        return (ClassDecl) anonymousClassDeclaration.get();
    }

    //@formatter:off
    @Override public Method getMethod() { return ctor; }
    @Override public IndexedInstructionCollection<Instruction> getArguments() { return arguments; }
    public void setType(ClassType type) { this.type = type; }
    //@formatter:on

    public void setMethod(Method ctor) {
        this.ctor = ctor;
        setType(ctor.getDeclaringClass());
    }

    public @Nullable Instruction getTarget() {
        if (!TypeSystem.isConstructedViaTargetInstance(type))
            return null;

        return arguments.get(hasEnclosingScopeInstanceParam ? 1 : 0);
    }
}
