package net.covers1624.coffeegrinder.bytecode.insns.tags;

import net.covers1624.coffeegrinder.bytecode.insns.LdcInsn;

/**
 * Created by covers1624 on 17/9/21.
 */
public class PotentialConstantLookupTag implements InsnTag {

    public final boolean isStatic;
    public final LdcInsn ldc;

    public PotentialConstantLookupTag(boolean isStatic, LdcInsn ldc) {
        this.isStatic = isStatic;
        this.ldc = ldc;
    }

    @Override
    public String describe() {
        return "PotentialConstantLookup(" + (isStatic ? "Static" : "Instance") + ")";
    }
}
