package net.covers1624.coffeegrinder.bytecode.transform;

import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;

/**
 * A transform capable of running over an entire {@link MethodDecl}.
 * <p>
 * Created by covers1624 on 21/2/21.
 */
public interface MethodTransformer extends Transformer {

    /**
     * Transform the {@link MethodDecl}.
     *
     * @param function The function to transform.
     * @param ctx      The {@link MethodTransformContext}.
     */
    void transform(MethodDecl function, MethodTransformContext ctx);

}
