package net.covers1624.coffeegrinder.type;

import com.google.common.collect.ImmutableList;
import net.covers1624.coffeegrinder.bytecode.AccessFlag;
import net.covers1624.coffeegrinder.util.EnumBitSet;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

import java.util.List;

/**
 * Created by covers1624 on 7/4/22.
 */
public class GetClassMethod extends Method {

    private static final Type DESC = Type.getMethodType("()Ljava/lang/Class;");

    private final ReferenceType targetType;
    private final ClassType tClass;

    public GetClassMethod(ReferenceType targetType, ClassType tClass) {
        this.targetType = targetType;
        this.tClass = tClass;
    }

    @Override
    public Type getDescriptor() {
        return DESC;
    }

    @Override
    @Nullable
    public Object getDefaultAnnotationValue() {
        return null;
    }

    @Override
    public ClassType getDeclaringClass() {
        return TypeSystem.objectType(tClass);
    }

    @Override
    public List<Parameter> getParameters() {
        return ImmutableList.of();
    }

    @Override
    public AType getReturnType() {
        return new ParameterizedClass(null, tClass, ImmutableList.of(WildcardType.createExtends(targetType)));
    }

    @Override
    public boolean isConstructor() {
        return false;
    }

    @Override
    public EnumBitSet<AccessFlag> getAccessFlags() {
        return EnumBitSet.of(
                AccessFlag.PUBLIC,
                AccessFlag.NATIVE,
                AccessFlag.FINAL
        );
    }

    @Override
    public List<ReferenceType> getExceptions() {
        return ImmutableList.of();
    }

    @Override
    public Method asRaw() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return "getClass";
    }

    @Override
    public List<TypeParameter> getTypeParameters() {
        return ImmutableList.of();
    }

    @Override
    public Method getDeclaration() {
        return this;
    }
}
