package net.covers1624.coffeegrinder.type.asm;

import com.google.common.collect.ImmutableList;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.ITypeParameterizedMember;
import net.covers1624.coffeegrinder.type.ReferenceType;
import net.covers1624.coffeegrinder.type.TypeResolver;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

import java.util.List;
import java.util.Objects;

/**
 * Created by covers1624 on 24/12/21.
 */
public class MethodSignatureParser extends SignatureParser {

    @Nullable
    private AType returnType;
    private final ImmutableList.Builder<AType> parameters = ImmutableList.builder();
    private final ImmutableList.Builder<ReferenceType> exceptions = ImmutableList.builder();

    private MethodSignatureParser(TypeResolver typeResolver, ITypeParameterizedMember scope) {
        super(typeResolver, scope);
    }

    public static MethodSignatureParser parse(TypeResolver typeResolver, ITypeParameterizedMember scope, String signature) {
        MethodSignatureParser parser = new MethodSignatureParser(typeResolver, scope);
        new SignatureReader(signature).accept(parser);
        return parser;
    }

    public AType getReturnType() {
        return Objects.requireNonNull(returnType);
    }

    public List<AType> getParameters() {
        return parameters.build();
    }

    public List<ReferenceType> getExceptions() {
        return exceptions.build();
    }

    @Override
    public SignatureVisitor visitParameterType() {
        return new ReferenceTypeSignatureParser(typeResolver, scope) {
            @Override
            public void endType(AType type) {
                parameters.add(type);
            }
        };
    }

    @Override
    public SignatureVisitor visitReturnType() {
        return new ReferenceTypeSignatureParser(typeResolver, scope) {
            @Override
            public void endType(AType type) {
                returnType = type;
            }
        };
    }

    @Override
    public SignatureVisitor visitExceptionType() {
        return new ReferenceTypeSignatureParser(typeResolver, scope) {
            @Override
            public void endType(AType type) {
                exceptions.add((ReferenceType) type);
            }
        };
    }
}
