/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.bytecode.InstructionSlot;
import net.covers1624.coffeegrinder.bytecode.insns.BinaryOp;
import net.covers1624.coffeegrinder.bytecode.insns.Reference;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.util.EnumBitSet;

public class CompoundAssignment
extends Instruction {
    private final BinaryOp op;
    private final InstructionSlot<Reference> reference = new InstructionSlot(this);
    private final InstructionSlot<Instruction> value = new InstructionSlot(this);

    public CompoundAssignment(BinaryOp op, Reference reference, Instruction value) {
        super(InsnOpcode.COMPOUND_ASSIGNMENT);
        this.op = op;
        this.reference.set(reference);
        this.value.set(value);
    }

    @Override
    public AType getResultType() {
        return this.getReference().getType();
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        AType result = this.getResultType();
        boolean doesThrow = !(result != PrimitiveType.INT && result != PrimitiveType.LONG || this.op != BinaryOp.DIV && this.op != BinaryOp.REM);
        return doesThrow ? InstructionFlag.MAY_THROW.toSet() : InstructionFlag.NONE;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitCompoundAssignment(this, ctx);
    }

    @Override
    protected void onChildModified() {
        super.onChildModified();
        if (this.isConnected()) {
            this.getReference().setReadFrom(true);
            this.getReference().setWrittenTo(true);
        }
    }

    @Override
    protected void onConnected() {
        super.onConnected();
        this.getReference().setReadFrom(true);
        this.getReference().setWrittenTo(true);
    }

    public Reference getReference() {
        return this.reference.get();
    }

    public Instruction getValue() {
        return this.value.get();
    }

    public BinaryOp getOp() {
        return this.op;
    }
}

