/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.insns;

import java.util.Objects;
import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionSlot;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.insns.Reference;
import net.covers1624.coffeegrinder.bytecode.insns.SimpleInstruction;
import net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.TypeSystem;
import org.jetbrains.annotations.Nullable;

public class Load
extends SimpleInstruction {
    private final InstructionSlot<Reference> reference = new InstructionSlot(this);
    @Nullable
    private AType cachedReferenceType;
    @Nullable
    private AType resultType;

    public Load(Reference reference) {
        super(InsnOpcode.LOAD);
        this.reference.set(reference);
    }

    @Override
    public AType getResultType() {
        AType type = this.getReference().getType();
        if (!type.equals(this.cachedReferenceType)) {
            this.cachedReferenceType = type;
            this.resultType = TypeSystem.capture(this.cachedReferenceType);
        }
        assert (this.resultType != null);
        return this.resultType;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitLoad(this, ctx);
    }

    @Override
    public Load copy() {
        return new Load(this.getReference().copy());
    }

    public Reference getReference() {
        return this.reference.get();
    }

    @Override
    protected void onChildModified() {
        super.onChildModified();
        if (this.isConnected()) {
            this.getReference().setReadFrom(true);
        }
    }

    @Override
    protected void onConnected() {
        super.onConnected();
        this.getReference().setReadFrom(true);
    }

    public LocalVariable getVariable() {
        return Objects.requireNonNull(LoadStoreMatching.matchLocalRef((Instruction)this.getReference()), (String)"Not a LocalReference").variable;
    }
}

