/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.matching;

import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.Binary;
import net.covers1624.coffeegrinder.bytecode.insns.BinaryOp;
import net.covers1624.coffeegrinder.bytecode.insns.Cast;
import net.covers1624.coffeegrinder.bytecode.insns.CompoundAssignment;
import net.covers1624.coffeegrinder.bytecode.insns.LdcNumber;
import net.covers1624.coffeegrinder.bytecode.insns.Store;
import net.covers1624.coffeegrinder.bytecode.matching.LdcMatching;
import org.jetbrains.annotations.Nullable;

public class AssignmentMatching {
    @Nullable
    public static CompoundAssignment matchCompoundAssignment(@Nullable Instruction insn) {
        if (insn == null || insn.opcode != InsnOpcode.COMPOUND_ASSIGNMENT) {
            return null;
        }
        return (CompoundAssignment)insn;
    }

    @Nullable
    public static CompoundAssignment matchCompoundAssignment(@Nullable Instruction insn, BinaryOp op) {
        CompoundAssignment assignment = AssignmentMatching.matchCompoundAssignment(insn);
        if (assignment == null || assignment.getOp() != op) {
            return null;
        }
        return assignment;
    }

    @Nullable
    public static CompoundAssignment matchCompoundAssignment(@Nullable Instruction insn, BinaryOp op, int ldc) {
        CompoundAssignment assignment = AssignmentMatching.matchCompoundAssignment(insn, op);
        if (assignment == null) {
            return null;
        }
        if (LdcMatching.matchLdcInt(assignment.getValue(), ldc) == null) {
            return null;
        }
        return assignment;
    }

    @Nullable
    public static CompoundAssignment matchPreInc(@Nullable Instruction insn) {
        CompoundAssignment assignment = AssignmentMatching.matchCompoundAssignment(insn);
        if (assignment == null) {
            return null;
        }
        if (assignment.getOp() != BinaryOp.ADD && assignment.getOp() != BinaryOp.SUB) {
            return null;
        }
        LdcNumber ldc = LdcMatching.matchLdcNumber(assignment.getValue());
        if (ldc == null || ldc.getValue().doubleValue() != 1.0) {
            return null;
        }
        return assignment;
    }

    @Nullable
    public static Binary matchStoreArgBinaryWithPossibleCast(Store store) {
        Cast c;
        Instruction value = store.getValue();
        if (value.opcode == InsnOpcode.CHECK_CAST && (c = (Cast)value).getType() == store.getReference().getType()) {
            value = c.getArgument();
        }
        if (value.opcode != InsnOpcode.BINARY) {
            return null;
        }
        return (Binary)value;
    }
}

