/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.testengine.testcase;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.covers1624.coffeegrinder.testengine.api.DecompileTest;
import net.covers1624.coffeegrinder.testengine.api.Target;
import net.covers1624.coffeegrinder.testengine.api.VersionFilter;
import net.covers1624.coffeegrinder.testengine.testcase.TestCase;
import net.covers1624.coffeegrinder.testengine.testcase.TestCaseEngineDescriptor;
import net.covers1624.coffeegrinder.testengine.testcase.target.BytecodeRoundTripTargetStepDescriptor;
import net.covers1624.coffeegrinder.testengine.testcase.target.CompileTargetStepDescriptor;
import net.covers1624.coffeegrinder.testengine.testcase.target.ProcessTargetStepDescriptor;
import net.covers1624.coffeegrinder.testengine.testcase.target.SourceTargetStepDescriptor;
import net.covers1624.coffeegrinder.testengine.testcase.target.TargetStepDescriptor;
import net.covers1624.coffeegrinder.testengine.testcase.target.TestCaseDescriptor;
import net.covers1624.quack.asm.annotation.AnnotationLoader;
import net.covers1624.quack.collection.FastStream;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;
import org.objectweb.asm.ClassReader;

public class DecompileTestCaseEngine
implements TestEngine {
    private final String id;
    private final String enableProp;

    public DecompileTestCaseEngine() {
        this("testcase-engine", "coffeegrinder.testcases");
    }

    public DecompileTestCaseEngine(String id, String enableProp) {
        this.id = id;
        this.enableProp = enableProp;
    }

    public final TestDescriptor discover(EngineDiscoveryRequest discoveryRequest, UniqueId rootId) {
        ConfigurationParameters config = discoveryRequest.getConfigurationParameters();
        if (!config.get(this.enableProp).isPresent()) {
            return new SkipEngineDescriptor(rootId);
        }
        try {
            TestCaseEngineDescriptor rootDescriptor = new TestCaseEngineDescriptor(this, rootId, discoveryRequest.getConfigurationParameters());
            for (TestCase test : this.locateTests(rootDescriptor)) {
                TestCaseDescriptor caseDesc = rootDescriptor.addTestCase(test);
                UniqueId caseId = caseDesc.getUniqueId();
                for (Target target : Target.values()) {
                    caseDesc.addChild((TestDescriptor)this.makeTestDescriptor(target, caseId));
                }
                rootDescriptor.addChild((TestDescriptor)caseDesc);
            }
            return rootDescriptor;
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to setup engine.", ex);
        }
    }

    private TargetStepDescriptor makeTestDescriptor(Target target, UniqueId parentId) {
        switch (target) {
            case PROCESS: {
                return new ProcessTargetStepDescriptor(parentId);
            }
            case SOURCE: {
                return new SourceTargetStepDescriptor(parentId);
            }
            case COMPILE: {
                return new CompileTargetStepDescriptor(parentId);
            }
            case BYTECODE_ROUND_TRIP: {
                return new BytecodeRoundTripTargetStepDescriptor(parentId);
            }
        }
        throw new RuntimeException("Switch falloff.");
    }

    protected List<TestCase> locateTests(TestCaseEngineDescriptor root) throws IOException {
        List<Path> files = root.inputClassPaths.allFiles();
        files.removeIf(e -> !e.getFileName().toString().endsWith(".class"));
        files.sort(Comparator.naturalOrder());
        LinkedList<TestCase> tests = new LinkedList<TestCase>();
        for (Path file : files) {
            DecompileTest annotation;
            ClassReader cr = new ClassReader(Files.readAllBytes(file));
            AnnotationLoader al = new AnnotationLoader();
            cr.accept(al.forClass(), 1);
            Object[] anns = (DecompileTest[])al.getAnnotations(DecompileTest.class);
            if (anns == null || (annotation = (DecompileTest)FastStream.of((Object[])anns).filter(e -> VersionFilter.matchesCurrentJVM(e.filter())).lastOrDefault()) == null) continue;
            tests.add(new TestCase(cr.getClassName().replace('/', '.'), annotation.value(), TestCase.BrokenData.from(annotation), (Map<String, Map<String, String>>)ImmutableMap.of()));
        }
        return tests;
    }

    public void execute(ExecutionRequest request) {
        TestDescriptor rootDescriptor = request.getRootTestDescriptor();
        if (rootDescriptor instanceof SkipEngineDescriptor) {
            return;
        }
        if (!(rootDescriptor instanceof TestCaseEngineDescriptor)) {
            throw new RuntimeException("Expected TestCaseEngineDescriptor, got " + rootDescriptor.getClass());
        }
        TestCaseEngineDescriptor baseDescriptor = (TestCaseEngineDescriptor)rootDescriptor;
        try {
            baseDescriptor.execute(request.getEngineExecutionListener());
            this.postProcess(baseDescriptor);
        }
        catch (Throwable ex) {
            throw new JUnitException("Unhandled executing tests.", ex);
        }
    }

    protected void postProcess(TestCaseEngineDescriptor root) throws IOException {
    }

    public final String getId() {
        return this.id;
    }

    public final Optional<String> getGroupId() {
        return Optional.of("net.covers1624.coffeegrinder");
    }

    public final Optional<String> getArtifactId() {
        return Optional.of("testframework");
    }

    private static class SkipEngineDescriptor
    extends EngineDescriptor {
        public SkipEngineDescriptor(UniqueId uniqueId) {
            super(uniqueId, "skip");
        }
    }
}

