/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.util.EnumBitSet;

public class DeadCode
extends Instruction {
    private final Instruction code;

    public DeadCode(Instruction code) {
        super(InsnOpcode.DEAD_CODE);
        this.code = code;
    }

    @Override
    public AType getResultType() {
        return PrimitiveType.VOID;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.NONE;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitDeadCode(this, ctx);
    }

    @Override
    protected void onConnected() {
        super.onConnected();
        this.code.addRef();
        this.code.remove();
    }

    @Override
    protected void onDisconnected() {
        super.onDisconnected();
        this.code.releaseRef();
    }

    public Instruction getCode() {
        return this.code;
    }
}

