/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers.generics;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.AbstractInvoke;
import net.covers1624.coffeegrinder.bytecode.insns.Cast;
import net.covers1624.coffeegrinder.bytecode.insns.Invoke;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.bytecode.insns.New;
import net.covers1624.coffeegrinder.bytecode.insns.tags.InsnTag;
import net.covers1624.coffeegrinder.bytecode.transform.ClassTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.generics.BoundSet;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.generics.GenericTransform;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.generics.InferenceSolution;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.ArrayType;
import net.covers1624.coffeegrinder.type.CapturedTypeVar;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.Method;
import net.covers1624.coffeegrinder.type.Parameter;
import net.covers1624.coffeegrinder.type.ParameterizedClass;
import net.covers1624.coffeegrinder.type.RawClass;
import net.covers1624.coffeegrinder.type.ReferenceType;
import net.covers1624.coffeegrinder.type.TypeParameter;
import net.covers1624.coffeegrinder.type.TypeSubstitutions;
import net.covers1624.coffeegrinder.type.TypeSystem;
import net.covers1624.coffeegrinder.type.TypeVariable;
import net.covers1624.coffeegrinder.type.WildcardType;
import net.covers1624.quack.collection.ColUtils;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.util.SneakyUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class GenericTransformInference {
    public static final InsnTag REQUIRED_CAST_TAG = () -> "InferenceRequired";

    public static void infer(GenericTransform.ReturnTypeInfo ret, AbstractInvoke invoke, GenericTransform t, ClassTransformContext ctx) {
        ctx.pushStep("Infer type args for " + GenericTransformInference.describe(invoke));
        InferenceSolution res = GenericTransformInference.resolve(invoke, ret, false);
        if (GenericTransformInference.applyPartialSolutionToLambdas(t, res)) {
            res = GenericTransformInference.resolve(invoke, ret, true);
        }
        GenericTransformInference.applyResolution(invoke, res, ctx);
        GenericTransformInference.applyPartialSolutionToLambdas(t, res);
        ctx.popStep();
    }

    private static boolean applyPartialSolutionToLambdas(GenericTransform t, InferenceSolution res) {
        boolean any = false;
        for (Pair<MethodDecl, ReferenceType> e : res.lambdaTypes) {
            MethodDecl lambda = (MethodDecl)e.getLeft();
            ReferenceType fType = (ReferenceType)e.getRight();
            if (!TypeSystem.areErasuresEqual(fType, lambda.getResultType())) continue;
            t.visitLambda(lambda, fType);
            any = true;
        }
        for (InferenceSolution nested : res.nested.values()) {
            any |= GenericTransformInference.applyPartialSolutionToLambdas(t, nested);
        }
        return any;
    }

    private static void applyResolution(AbstractInvoke insn, InferenceSolution resolution, ClassTransformContext ctx) {
        assert (!resolution.hasFailed()) : resolution.failureReason;
        Method method = insn.getMethod();
        if (insn.opcode == InsnOpcode.INVOKE) {
            Invoke invoke = (Invoke)insn;
            invoke.setMethod(TypeSubstitutions.parameterize(method.getDeclaringClass(), method, resolution));
            invoke.setResultType(resolution.retType);
            invoke.explicitTypeArgs = resolution.explicit;
        } else if (insn.opcode == InsnOpcode.NEW) {
            New newInsn = (New)insn;
            ClassType type = (ClassType)resolution.retType;
            newInsn.setMethod(TypeSubstitutions.parameterize(type, method, resolution));
            newInsn.explicitClassTypeArgs = resolution.explicit;
            boolean bl = newInsn.explicitTypeArgs = resolution.explicit && method.hasTypeParameters();
        }
        if (resolution.polyFailed != null) {
            ctx.pushStep("Tag cast on return value as required");
            if (insn.getParent().opcode != InsnOpcode.CHECK_CAST) {
                ReferenceType castType = resolution.polyFailed;
                if (!TypeSystem.isCastableTo((ReferenceType)insn.getResultType(), castType, false)) {
                    castType = TypeSystem.erase(castType);
                }
                insn.replaceWith(new Cast(insn, castType));
            }
            insn.getParent().setTag(REQUIRED_CAST_TAG);
            ctx.popStep();
        }
        for (Map.Entry<AbstractInvoke, InferenceSolution> entry : resolution.nested.entrySet()) {
            ctx.pushStep("Infer nested " + GenericTransformInference.describe(entry.getKey()));
            GenericTransformInference.applyResolution(entry.getKey(), entry.getValue(), ctx);
            ctx.popStep();
        }
    }

    private static String describe(AbstractInvoke invoke) {
        if (invoke.opcode == InsnOpcode.NEW) {
            return "new " + invoke.getMethod().getDeclaringClass().getName();
        }
        return invoke.getMethod().getName();
    }

    private static InferenceSolution resolve(AbstractInvoke invoke, GenericTransform.ReturnTypeInfo ret, boolean lambdaInference) {
        GenericTransformBoundSet monoBounds = GenericTransformInference.monomorphicBounds(invoke, lambdaInference);
        InferenceSolution sln = monoBounds.copy().getSolution();
        if (!BoundSet.isPoly(invoke.getMethod()) || ret.expectedType() == null) {
            return sln;
        }
        if (ret.type != null && !sln.hasRawArgs) {
            InferenceSolution polySln = GenericTransformInference.addPolyRetTypeAndResolve(monoBounds.copy(), (ReferenceType)ret.type);
            sln = !polySln.hasFailed() ? polySln : sln.polyFailed((ReferenceType)ret.type);
        }
        if (sln.hasRawArgs && monoBounds.hasParameterizedRetType()) {
            return sln;
        }
        ReferenceType hintType = ret.explicitTypeHint;
        if (hintType == null) {
            hintType = (ReferenceType)ret.type;
        }
        AType currentRetType = sln.retType;
        if (!sln.hasFailed() && TypeSystem.isAssignableTo(currentRetType, (AType)hintType)) {
            return sln;
        }
        InferenceSolution explicitSln = GenericTransformInference.addExplicitHintAndResolve(monoBounds, invoke.getMethod(), hintType);
        if (explicitSln.hasFailed() || explicitSln.equals(sln)) {
            return sln;
        }
        return explicitSln.makeExplicit();
    }

    private static boolean containsRaw(AType type) {
        if (type instanceof RawClass) {
            return true;
        }
        if (type instanceof ArrayType) {
            return GenericTransformInference.containsRaw(((ArrayType)type).getElementType());
        }
        if (type instanceof ParameterizedClass) {
            return FastStream.of(((ParameterizedClass)type).getTypeArguments()).anyMatch(GenericTransformInference::containsRaw);
        }
        return false;
    }

    private static boolean isRaw(AType type) {
        if (type instanceof RawClass) {
            return true;
        }
        if (type instanceof ArrayType) {
            return GenericTransformInference.isRaw(((ArrayType)type).getElementType());
        }
        return false;
    }

    private static InferenceSolution addPolyRetTypeAndResolve(GenericTransformBoundSet b, ReferenceType targetType) {
        b.constrainReturnAssignable(targetType);
        return b.getSolution();
    }

    private static InferenceSolution addExplicitHintAndResolve(GenericTransformBoundSet b, Method method, ReferenceType hintType) {
        if (b.hasParameterizedRetType()) {
            ClassType erasedType = (method.isConstructor() ? method.getDeclaringClass() : (ClassType)method.getReturnType()).asRaw();
            hintType = BoundSet.getHierarchyCompatibleType((ReferenceType)erasedType, hintType);
        }
        b.explicitHint = true;
        b.constrainReturnAssignable(hintType);
        return b.getSolution();
    }

    private static GenericTransformBoundSet monomorphicBounds(AbstractInvoke invoke, boolean lambdaInference) {
        return BoundSet.monomorphicBounds(invoke, (params, retType) -> new GenericTransformBoundSet((Iterable<TypeParameter>)params, (AType)retType, lambdaInference));
    }

    private static class GenericTransformBoundSet
    extends BoundSet {
        private final List<Pair<MethodDecl, ReferenceType>> lambdas = new LinkedList<Pair<MethodDecl, ReferenceType>>();
        private final boolean lambdaInference;
        public boolean explicitHint;
        @Nullable
        private OptionalBoundSource currentOption;
        @Nullable
        private Set<OptionalBoundSource> incorporating;

        public GenericTransformBoundSet(Iterable<TypeParameter> typeParameters, AType retType, boolean lambdaInference) {
            super(typeParameters, retType);
            this.lambdaInference = lambdaInference;
        }

        private GenericTransformBoundSet(GenericTransformBoundSet other) {
            super(other);
            this.lambdas.addAll(other.lambdas);
            this.lambdaInference = other.lambdaInference;
            assert (other.incorporating == null);
            assert (other.currentOption == null);
        }

        public boolean hasParameterizedRetType() {
            return this.infVarRetType instanceof ParameterizedClass;
        }

        @Override
        protected void lambdaParamsCanReceiveFunctionalInterfaceMethodType(List<AType> params, List<Parameter> fParams) {
            if (this.explicitHint) {
                super.lambdaParamsCanReceiveFunctionalInterfaceMethodType(params, fParams);
            }
        }

        @Override
        protected void retTypeAssignable(MethodDecl lambda, ReferenceType retType) {
            if (!this.lambdaInference) {
                this.optional(new OptionalBoundSource(), () -> this.assignable((ReferenceType)lambda.getReturnType(), retType));
                return;
            }
            super.retTypeAssignable(lambda, retType);
        }

        @Override
        protected void assignable(MethodDecl lambda, ReferenceType t) {
            this.lambdas.add((Pair<MethodDecl, ReferenceType>)Pair.of((Object)lambda, (Object)t));
            super.assignable(lambda, t);
        }

        @Override
        protected void assignable(Instruction expr, ReferenceType t) {
            if (expr.opcode == InsnOpcode.CHECK_CAST) {
                this.assignable(((Cast)expr).getArgument(), t);
                return;
            }
            super.assignable(expr, t);
        }

        @Override
        protected void assignable(Instruction expr, ReferenceType resultType, ReferenceType t, @Nullable BoundSet polyBounds) {
            Cast cast;
            if (expr.getParent().opcode == InsnOpcode.CHECK_CAST && !this.couldBeSubtypeOf(resultType, (ReferenceType)(cast = (Cast)expr.getParent()).getType())) {
                if (resultType instanceof BoundSet.InferenceVar) {
                    assert (polyBounds != null);
                    InferenceSolution r = ((GenericTransformBoundSet)polyBounds).getSolution();
                    resultType = r.mapParam(((BoundSet.InferenceVar)resultType).param);
                }
                resultType = GenericTransformBoundSet.getHierarchyCompatibleType((ReferenceType)cast.getType(), resultType);
            }
            if (resultType instanceof RawClass) {
                this.hasRawArgs = true;
            }
            if (resultType instanceof BoundSet.InferenceVar) {
                this.assignable(resultType, t);
                return;
            }
            if (resultType instanceof TypeVariable) {
                this.assignable(resultType, t);
                return;
            }
            if (GenericTransformBoundSet.isParameterized(t)) {
                this.subtype(TypeSystem.erase(resultType), t);
                this.argsAssignableOptional(resultType, t);
                return;
            }
            if (t instanceof BoundSet.InferenceVar) {
                ReferenceType finalResultType = resultType;
                this.optional(new AssignmentBoundSource(resultType, t), () -> this.assignable(finalResultType, t));
                return;
            }
            this.assignable(resultType, t);
        }

        private boolean extendsTypeParamInScope(TypeParameter param, Instruction scope) {
            while (param.getUpperBound() instanceof TypeParameter) {
                if (!GenericTransform.typeParameterInScope(scope, param = (TypeParameter)param.getUpperBound())) continue;
                return true;
            }
            return false;
        }

        private static boolean isParameterized(AType t) {
            return t instanceof ParameterizedClass || t instanceof ArrayType && GenericTransformBoundSet.isParameterized(((ArrayType)t).getElementType());
        }

        private void argsAssignableOptional(ReferenceType s, ReferenceType t) {
            if (t instanceof ArrayType) {
                this.argsAssignableOptional((ReferenceType)((ArrayType)s).getElementType(), (ReferenceType)((ArrayType)t).getElementType());
                return;
            }
            this.argsAssignableOptional(s, (ParameterizedClass)t);
        }

        private void argsAssignableOptional(ReferenceType s, ParameterizedClass t) {
            ClassType tOnS = TypeSystem.findParameterizationOrNull(t.getDeclaration(), s);
            if (tOnS == null) {
                this.fail(s + " not a subtype of " + t);
                return;
            }
            if (tOnS instanceof RawClass) {
                return;
            }
            List<ReferenceType> tArgs = t.getTypeArguments();
            List<ReferenceType> sArgs = ((ParameterizedClass)tOnS).getTypeArguments();
            for (int i = 0; i < tArgs.size(); ++i) {
                ReferenceType tArg = tArgs.get(i);
                ReferenceType sArg = sArgs.get(i);
                this.optional(new OptionalBoundSource(), () -> this.containedBy(sArg, tArg));
            }
        }

        public InferenceSolution getSolution() {
            if (this.failure != null) {
                return InferenceSolution.failure(this.failure);
            }
            try {
                return this.getSolution(this.solve());
            }
            catch (BoundSet.ResolveFailedException ex) {
                return InferenceSolution.failure(ex.getMessage());
            }
        }

        private InferenceSolution getSolution(BoundSet.InferenceVarMapper mapper) {
            AType retType = TypeSubstitutions.subst(this.infVarRetType, (TypeSubstitutions.TypeMapper)mapper);
            if (retType instanceof ReferenceType && this.hasRawArgs) {
                retType = TypeSystem.erase((ReferenceType)retType);
            }
            InferenceSolution sln = InferenceSolution.success((Map<TypeParameter, ReferenceType>)FastStream.of(this.vars.entrySet()).toImmutableMap(Map.Entry::getKey, e -> mapper.mapParam((BoundSet.InferenceVar)e.getValue())), retType, (Map<AbstractInvoke, InferenceSolution>)FastStream.of(this.nestedVars.entrySet()).toImmutableMap(Map.Entry::getKey, e -> ((GenericTransformBoundSet)e.getValue()).getSolution(mapper)), (List<Pair<MethodDecl, ReferenceType>>)FastStream.of(this.lambdas).map(e -> Pair.of((Object)e.getLeft(), (Object)TypeSubstitutions.subst((ReferenceType)e.getRight(), (TypeSubstitutions.TypeMapper)mapper))).toImmutableList(), this.hasRawArgs);
            return sln;
        }

        @Override
        protected Map<BoundSet.InferenceVar, ReferenceType> solveVars(List<BoundSet.InferenceVar> vars, BoundSet.InferenceVarMapper solved) {
            ImmutableList opts = FastStream.of(vars).flatMap(var -> this.boundsFor((BoundSet.InferenceVar)var).allOpts()).distinct().filter(OptionalBoundSource::canDisable).toImmutableList();
            return this.tryDisablingOptions((List<OptionalBoundSource>)ImmutableList.of(), (List<OptionalBoundSource>)opts, () -> super.solveVars(vars, solved)).sln;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Result tryDisablingOptions(List<OptionalBoundSource> disabled, List<OptionalBoundSource> remaining, Supplier<Map<BoundSet.InferenceVar, ReferenceType>> resultImpl) {
            Result result;
            this.setDisabled(disabled, true);
            try {
                result = new Result(resultImpl.get(), FastStream.of(disabled).doubleSum(OptionalBoundSource::cost));
            }
            catch (BoundSet.ResolveFailedException ex) {
                try {
                    if (remaining.isEmpty()) {
                        throw ex;
                    }
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.setDisabled(disabled, false);
                }
            }
            this.setDisabled(disabled, false);
            return result;
            Result best = null;
            for (int i = remaining.size() - 1; i >= 0; --i) {
                OptionalBoundSource next = remaining.get(i);
                try {
                    Result r = this.tryDisablingOptions(GenericTransformBoundSet.concat(disabled, next), remaining.subList(i + 1, remaining.size()), resultImpl);
                    if (best != null && !(r.cost <= best.cost)) continue;
                    best = r;
                    continue;
                }
                catch (BoundSet.ResolveFailedException ex) {
                    if (i != 0 || best != null) continue;
                    throw ex;
                }
            }
            assert (best != null);
            return best;
        }

        private static <T> List<T> concat(List<T> list, T other) {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll(list);
            builder.add(other);
            return builder.build();
        }

        private void setDisabled(Iterable<OptionalBoundSource> opts, boolean disabled) {
            for (OptionalBoundSource opt : opts) {
                for (Bound bound : opt.bounds) {
                    bound.disabled = disabled;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void optional(OptionalBoundSource opt, Runnable action) {
            OptionalBoundSource prev = this.currentOption;
            this.currentOption = opt;
            try {
                action.run();
            }
            finally {
                this.currentOption = prev;
            }
        }

        private boolean couldBeSubtypeOf(ReferenceType s, ReferenceType t) {
            if (s instanceof BoundSet.InferenceVar) {
                DetailedVarBounds b = this.boundsFor((BoundSet.InferenceVar)s);
                return b.equalTypes(TypeSubstitutions.TypeSubstApplier.NONE).allMatch(e -> e instanceof BoundSet.InferenceVar || this.couldBeSubtypeOf((ReferenceType)e, t)) && b.lowerTypes(TypeSubstitutions.TypeSubstApplier.NONE).allMatch(l -> l instanceof BoundSet.InferenceVar || this.couldBeSubtypeOf((ReferenceType)l, t));
            }
            if (t instanceof ParameterizedClass) {
                ParameterizedClass tParam = (ParameterizedClass)t;
                ClassType tOnS = TypeSystem.findParameterizationOrNull(tParam.getDeclaration(), s);
                if (tOnS == null) {
                    return false;
                }
                if (tOnS instanceof RawClass) {
                    return true;
                }
                List<ReferenceType> tArgs = tParam.getTypeArguments();
                List<ReferenceType> sArgs = ((ParameterizedClass)tOnS).getTypeArguments();
                for (int i = 0; i < tArgs.size(); ++i) {
                    if (this.couldBeContainedBy(sArgs.get(i), tArgs.get(i))) continue;
                    return false;
                }
                return true;
            }
            return TypeSystem.isAssignableTo(s, t);
        }

        private boolean couldBeContainedBy(ReferenceType s, ReferenceType t) {
            if (t instanceof BoundSet.InferenceVar) {
                DetailedVarBounds b = this.boundsFor((BoundSet.InferenceVar)t);
                return b.equalTypes(TypeSubstitutions.TypeSubstApplier.NONE).allMatch(e -> e instanceof BoundSet.InferenceVar || this.couldBeEqual((ReferenceType)e, s)) && b.upperTypes(TypeSubstitutions.TypeSubstApplier.NONE).allMatch(u -> u instanceof BoundSet.InferenceVar || this.couldBeSubtypeOf(s, (ReferenceType)u)) && b.lowerTypes(TypeSubstitutions.TypeSubstApplier.NONE).allMatch(l -> l instanceof BoundSet.InferenceVar || this.couldBeSubtypeOf((ReferenceType)l, s));
            }
            if (s instanceof BoundSet.InferenceVar) {
                DetailedVarBounds b = this.boundsFor((BoundSet.InferenceVar)s);
                return b.equalTypes(TypeSubstitutions.TypeSubstApplier.NONE).allMatch(e -> e instanceof BoundSet.InferenceVar || this.couldBeContainedBy((ReferenceType)e, t)) && b.upperTypes(TypeSubstitutions.TypeSubstApplier.NONE).allMatch(u -> u instanceof BoundSet.InferenceVar || this.couldBeContainedBy((ReferenceType)u, t)) && b.lowerTypes(TypeSubstitutions.TypeSubstApplier.NONE).allMatch(l -> l instanceof BoundSet.InferenceVar || this.couldBeContainedBy((ReferenceType)l, t));
            }
            if (!(t instanceof WildcardType)) {
                return this.couldBeEqual(s, t);
            }
            if (((WildcardType)t).isSuper()) {
                return this.couldBeSubtypeOf(t.getLowerBound(), s.getLowerBound());
            }
            if (!(s instanceof WildcardType)) {
                return this.couldBeSubtypeOf(s, t.getUpperBound());
            }
            if (((WildcardType)s).isSuper()) {
                return this.couldBeEqual(TypeSystem.objectType(s), t.getUpperBound());
            }
            return this.couldBeSubtypeOf(s.getUpperBound(), t.getUpperBound());
        }

        private boolean couldBeEqual(ReferenceType t1, ReferenceType t2) {
            if (t1 instanceof BoundSet.InferenceVar) {
                return this.couldBeContainedBy(t2, t1);
            }
            if (t2 instanceof BoundSet.InferenceVar) {
                return this.couldBeEqual(t2, t1);
            }
            return t1.equals(t2);
        }

        @Override
        protected void failProperSubtype(ReferenceType s, ReferenceType t) {
            if (this.incorporating != null && ColUtils.anyMatch(this.incorporating, opt -> this.handleSubtypeIncorporation((OptionalBoundSource)opt, s, t))) {
                return;
            }
            super.failProperSubtype(s, t);
        }

        private boolean handleSubtypeIncorporation(OptionalBoundSource opt, ReferenceType s, ReferenceType t) {
            if (opt instanceof AssignmentBoundSource) {
                AssignmentBoundSource cOpt = (AssignmentBoundSource)opt;
                if (s != cOpt.s) {
                    return false;
                }
                if (t instanceof TypeParameter && TypeSystem.areErasuresEqual(s, t)) {
                    if (!cOpt.alternatives.contains(t)) {
                        assert (cOpt.alternatives.isEmpty());
                        cOpt.alternatives.add(t);
                    }
                    return true;
                }
            }
            return false;
        }

        @Override
        protected void fail(String reason) {
            if (this.incorporating != null ? !this.incorporating.isEmpty() : this.currentOption != null) {
                return;
            }
            super.fail(reason);
        }

        private Set<OptionalBoundSource> getBoundSources() {
            if (this.incorporating != null) {
                return this.incorporating;
            }
            if (this.currentOption != null) {
                return ImmutableSet.of((Object)this.currentOption);
            }
            return ImmutableSet.of();
        }

        protected DetailedVarBounds newVarBounds() {
            return new DetailedVarBounds(this);
        }

        protected DetailedVarBounds copyVarBounds(BoundSet.VarBounds<?> other) {
            return new DetailedVarBounds((BoundSet)this, (DetailedVarBounds)other);
        }

        protected DetailedVarBounds boundsFor(BoundSet.InferenceVar var) {
            return (DetailedVarBounds)super.boundsFor(var);
        }

        protected DetailedVarBounds boundsFor(TypeParameter param) {
            return (DetailedVarBounds)super.boundsFor(param);
        }

        @Override
        protected GenericTransformBoundSet makeNestedBoundSet(Iterable<TypeParameter> vars, AType retType) {
            return new GenericTransformBoundSet(vars, retType, false);
        }

        public GenericTransformBoundSet copy() {
            return new GenericTransformBoundSet(this);
        }

        private static class DetailedVarBounds
        extends BoundSet.VarBounds<Bound> {
            public DetailedVarBounds(BoundSet root) {
                super(root);
            }

            public DetailedVarBounds(BoundSet root, DetailedVarBounds other) {
                super(root, other);
            }

            @Override
            public GenericTransformBoundSet getRoot() {
                return (GenericTransformBoundSet)super.getRoot();
            }

            @Override
            protected Bound makeBound(ReferenceType t) {
                return new Bound(t, this.getRoot().getBoundSources());
            }

            @Override
            protected ReferenceType getType(Bound bound) {
                return bound.type;
            }

            @Override
            protected void boundAdded(Bound b) {
                for (OptionalBoundSource opt : b.opts) {
                    opt.bounds.add(b);
                }
            }

            @Override
            protected boolean isEncompassedBy(Bound b1, Bound b2) {
                return b1.type.equals(b2.type) && b1.opts.containsAll(b2.opts);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected <T1, T2> void incorporate(T1 b1, T2 b2, BiConsumer<T1, T2> action) {
                Set prev = this.getRoot().incorporating;
                ImmutableSet combined = ImmutableSet.of();
                if (b1 instanceof Bound) {
                    combined = Sets.union((Set)combined, ((Bound)b1).opts);
                }
                if (b2 instanceof Bound) {
                    combined = Sets.union((Set)combined, ((Bound)b2).opts);
                }
                this.getRoot().incorporating = (Set)combined;
                try {
                    action.accept(b1, b2);
                }
                finally {
                    this.getRoot().incorporating = prev;
                }
            }

            @Override
            protected FastStream<Bound> activeBounds(List<Bound> list) {
                return ((FastStream)SneakyUtils.unsafeCast(super.activeBounds(list))).filter(e -> !e.disabled);
            }

            public FastStream<OptionalBoundSource> allOpts() {
                return FastStream.of((Object[])new List[]{this.equalBounds, this.lowerBounds, this.upperBounds}).flatMap(this::activeBounds).flatMap(e -> e.opts);
            }
        }

        private static class Bound {
            public final ReferenceType type;
            public final Set<OptionalBoundSource> opts;
            public boolean disabled;

            public Bound(ReferenceType type, Set<OptionalBoundSource> opts) {
                this.type = type;
                this.opts = opts;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof Bound)) {
                    return false;
                }
                Bound other = (Bound)o;
                return this.type.equals(other.type) && this.opts.equals(other.opts);
            }

            public String toString() {
                if (this.opts.isEmpty()) {
                    return this.type.toString();
                }
                return "{" + FastStream.of(this.opts).join(", ") + "} " + this.type;
            }
        }

        private static class AssignmentBoundSource
        extends OptionalBoundSource {
            public final ReferenceType s;
            public final ReferenceType t;
            public LinkedList<ReferenceType> alternatives = new LinkedList();

            public AssignmentBoundSource(ReferenceType s, ReferenceType t) {
                this.s = s;
                this.t = t;
            }

            @Override
            public boolean canDisable() {
                return !this.alternatives.isEmpty();
            }
        }

        private static class OptionalBoundSource {
            private static final double CAPTURE_COST = 0.01;
            private static final double DEFAULT_COST = 1.0;
            List<Bound> bounds = new ArrayList<Bound>(4);

            private OptionalBoundSource() {
            }

            public double cost() {
                if (ColUtils.allMatch(this.bounds, b -> b.type instanceof CapturedTypeVar)) {
                    return 0.01;
                }
                return 1.0;
            }

            public String toString() {
                return String.format("opt#%1$04X", this.hashCode() & 0xFFFF);
            }

            public boolean canDisable() {
                return true;
            }
        }

        private static class Result {
            private final Map<BoundSet.InferenceVar, ReferenceType> sln;
            private final double cost;

            public Result(Map<BoundSet.InferenceVar, ReferenceType> sln, double cost) {
                this.sln = sln;
                this.cost = cost;
            }
        }
    }
}

