/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.matching;

import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.insns.BlockContainer;
import net.covers1624.coffeegrinder.bytecode.insns.Branch;
import net.covers1624.coffeegrinder.bytecode.insns.Leave;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.bytecode.insns.Return;
import net.covers1624.coffeegrinder.bytecode.insns.Throw;
import net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching;
import org.jetbrains.annotations.Nullable;

public class BranchLeaveMatching {
    @Nullable
    public static Return matchReturn(@Nullable Instruction insn) {
        if (insn == null || insn.opcode != InsnOpcode.RETURN) {
            return null;
        }
        return (Return)insn;
    }

    @Nullable
    public static Return matchReturn(@Nullable Instruction insn, MethodDecl method) {
        if (insn == null || insn.opcode != InsnOpcode.RETURN) {
            return null;
        }
        Return ret = (Return)insn;
        return ret.getMethod() == method ? ret : null;
    }

    @Nullable
    public static Leave matchLeave(@Nullable Instruction insn) {
        if (insn == null || insn.opcode != InsnOpcode.LEAVE) {
            return null;
        }
        return (Leave)insn;
    }

    @Nullable
    public static Leave matchLeave(@Nullable Instruction insn, BlockContainer container) {
        Leave leave = BranchLeaveMatching.matchLeave(insn);
        if (leave == null) {
            return null;
        }
        if (leave.getTargetContainer() != container) {
            return null;
        }
        return leave;
    }

    @Nullable
    public static Branch matchBranch(@Nullable Instruction insn) {
        if (!(insn instanceof Branch)) {
            return null;
        }
        return (Branch)insn;
    }

    @Nullable
    public static Branch matchBranch(@Nullable Instruction insn, Block targetBlock) {
        Branch branch = BranchLeaveMatching.matchBranch(insn);
        if (branch == null) {
            return null;
        }
        if (branch.getTargetBlock() != targetBlock) {
            return null;
        }
        return branch;
    }

    public static boolean compatibleExitInstruction(@Nullable Instruction exit1, @Nullable Instruction exit2) {
        if (exit1 == null || exit2 == null || exit1.opcode != exit2.opcode) {
            return false;
        }
        switch (exit1.opcode) {
            case BRANCH: {
                Branch br1 = (Branch)exit1;
                Branch br2 = (Branch)exit2;
                return br1.getTargetBlock() == br2.getTargetBlock();
            }
            case LEAVE: {
                Leave l1 = (Leave)exit1;
                Leave l2 = (Leave)exit2;
                return l1.getTargetContainer() == l2.getTargetContainer();
            }
        }
        return false;
    }

    @Nullable
    public static Throw matchThrow(@Nullable Instruction insn) {
        if (insn == null || insn.opcode != InsnOpcode.THROW) {
            return null;
        }
        return (Throw)insn;
    }

    @Nullable
    public static Throw matchThrow(@Nullable Instruction insn, LocalVariable variable) {
        Throw thr = BranchLeaveMatching.matchThrow(insn);
        if (thr == null) {
            return null;
        }
        if (LoadStoreMatching.matchLoadLocal(thr.getArgument(), variable) == null) {
            return null;
        }
        return thr;
    }
}

