/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.source;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.covers1624.coffeegrinder.bytecode.AccessFlag;
import net.covers1624.coffeegrinder.bytecode.IndexedInstructionCollection;
import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionCollection;
import net.covers1624.coffeegrinder.bytecode.insns.AbstractLoop;
import net.covers1624.coffeegrinder.bytecode.insns.ArrayElementReference;
import net.covers1624.coffeegrinder.bytecode.insns.ArrayLen;
import net.covers1624.coffeegrinder.bytecode.insns.Assert;
import net.covers1624.coffeegrinder.bytecode.insns.Binary;
import net.covers1624.coffeegrinder.bytecode.insns.BinaryOp;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.insns.BlockContainer;
import net.covers1624.coffeegrinder.bytecode.insns.Branch;
import net.covers1624.coffeegrinder.bytecode.insns.Cast;
import net.covers1624.coffeegrinder.bytecode.insns.ClassDecl;
import net.covers1624.coffeegrinder.bytecode.insns.Comparison;
import net.covers1624.coffeegrinder.bytecode.insns.CompoundAssignment;
import net.covers1624.coffeegrinder.bytecode.insns.Continue;
import net.covers1624.coffeegrinder.bytecode.insns.DeadCode;
import net.covers1624.coffeegrinder.bytecode.insns.DoWhileLoop;
import net.covers1624.coffeegrinder.bytecode.insns.FieldDecl;
import net.covers1624.coffeegrinder.bytecode.insns.FieldReference;
import net.covers1624.coffeegrinder.bytecode.insns.ForEachLoop;
import net.covers1624.coffeegrinder.bytecode.insns.ForLoop;
import net.covers1624.coffeegrinder.bytecode.insns.IfInstruction;
import net.covers1624.coffeegrinder.bytecode.insns.InstanceOf;
import net.covers1624.coffeegrinder.bytecode.insns.Invoke;
import net.covers1624.coffeegrinder.bytecode.insns.LdcBoolean;
import net.covers1624.coffeegrinder.bytecode.insns.LdcChar;
import net.covers1624.coffeegrinder.bytecode.insns.LdcClass;
import net.covers1624.coffeegrinder.bytecode.insns.LdcNull;
import net.covers1624.coffeegrinder.bytecode.insns.LdcNumber;
import net.covers1624.coffeegrinder.bytecode.insns.LdcString;
import net.covers1624.coffeegrinder.bytecode.insns.Leave;
import net.covers1624.coffeegrinder.bytecode.insns.Load;
import net.covers1624.coffeegrinder.bytecode.insns.LoadThis;
import net.covers1624.coffeegrinder.bytecode.insns.LocalReference;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.insns.LogicAnd;
import net.covers1624.coffeegrinder.bytecode.insns.LogicNot;
import net.covers1624.coffeegrinder.bytecode.insns.LogicOr;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.bytecode.insns.MethodReference;
import net.covers1624.coffeegrinder.bytecode.insns.Monitor;
import net.covers1624.coffeegrinder.bytecode.insns.New;
import net.covers1624.coffeegrinder.bytecode.insns.NewArray;
import net.covers1624.coffeegrinder.bytecode.insns.NewObject;
import net.covers1624.coffeegrinder.bytecode.insns.Nop;
import net.covers1624.coffeegrinder.bytecode.insns.ParameterVariable;
import net.covers1624.coffeegrinder.bytecode.insns.PostIncrement;
import net.covers1624.coffeegrinder.bytecode.insns.Reference;
import net.covers1624.coffeegrinder.bytecode.insns.Return;
import net.covers1624.coffeegrinder.bytecode.insns.Store;
import net.covers1624.coffeegrinder.bytecode.insns.Switch;
import net.covers1624.coffeegrinder.bytecode.insns.SwitchTable;
import net.covers1624.coffeegrinder.bytecode.insns.Synchronized;
import net.covers1624.coffeegrinder.bytecode.insns.Ternary;
import net.covers1624.coffeegrinder.bytecode.insns.Throw;
import net.covers1624.coffeegrinder.bytecode.insns.TryCatch;
import net.covers1624.coffeegrinder.bytecode.insns.TryFinally;
import net.covers1624.coffeegrinder.bytecode.insns.TryInstruction;
import net.covers1624.coffeegrinder.bytecode.insns.TryWithResources;
import net.covers1624.coffeegrinder.bytecode.insns.WhileLoop;
import net.covers1624.coffeegrinder.bytecode.insns.Yield;
import net.covers1624.coffeegrinder.bytecode.insns.tags.ErrorTag;
import net.covers1624.coffeegrinder.bytecode.matching.AssignmentMatching;
import net.covers1624.coffeegrinder.bytecode.matching.BranchLeaveMatching;
import net.covers1624.coffeegrinder.bytecode.matching.InvokeMatching;
import net.covers1624.coffeegrinder.bytecode.matching.LdcMatching;
import net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.NumericConstants;
import net.covers1624.coffeegrinder.source.AbstractSourceVisitor;
import net.covers1624.coffeegrinder.source.EscapeUtils;
import net.covers1624.coffeegrinder.source.LineBuffer;
import net.covers1624.coffeegrinder.source.OperatorPrecedence;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.AnnotationData;
import net.covers1624.coffeegrinder.type.AnnotationSupplier;
import net.covers1624.coffeegrinder.type.ArrayType;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.Field;
import net.covers1624.coffeegrinder.type.Method;
import net.covers1624.coffeegrinder.type.Parameter;
import net.covers1624.coffeegrinder.type.ParameterizedMethod;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.type.ReferenceType;
import net.covers1624.coffeegrinder.type.TypeAnnotationData;
import net.covers1624.coffeegrinder.type.TypeResolver;
import net.covers1624.coffeegrinder.type.TypeSystem;
import net.covers1624.coffeegrinder.util.EnumBitSet;
import net.covers1624.coffeegrinder.util.None;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.util.SneakyUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.Nullable;

public class JavaSourceVisitor
extends AbstractSourceVisitor {
    private final TypeResolver typeResolver;
    private final NumericConstants numericConstants;
    private final LinkedList<ClassDecl> classStack = new LinkedList();
    private final LinkedList<MethodDecl> functionStack = new LinkedList();
    private final Map<LocalVariable, String> variableNames = new HashMap<LocalVariable, String>();
    private final Set<LocalVariable> declaredVariables = new HashSet<LocalVariable>();
    private final Set<Reference> localRefDeclarations = new HashSet<Reference>();
    private final Set<Field> declaredFields = new HashSet<Field>();

    public JavaSourceVisitor(TypeResolver typeResolver) {
        super(typeResolver);
        this.typeResolver = typeResolver;
        this.numericConstants = new NumericConstants(typeResolver);
        this.importCollector.setConstantPrinter(num -> {
            Instruction unfolded = this.numericConstants.getReplacement(num);
            if (unfolded != null) {
                unfolded.addRef();
                return this.lines(unfolded);
            }
            return this.lines(new LdcNumber(num));
        });
    }

    public void pushScope() {
        this.pushIndent();
        this.importCollector.pushVariableScope();
    }

    public void popScope() {
        this.popIndent();
        this.importCollector.popVariableScope();
    }

    private LineBuffer end(LineBuffer buffer, boolean end) {
        if (!end) {
            return buffer;
        }
        if (buffer.lines.isEmpty()) {
            return buffer;
        }
        return buffer.append(";");
    }

    private boolean shouldEnd(Instruction insn) {
        switch (insn.opcode) {
            case DEAD_CODE: 
            case BLOCK: 
            case BLOCK_CONTAINER: 
            case CLASS_DECL: 
            case FOR_EACH_LOOP: 
            case FOR_LOOP: 
            case IF: 
            case SWITCH: 
            case SWITCH_TABLE: 
            case SYNCHRONIZED: 
            case TRY_CATCH: 
            case TRY_FINALLY: 
            case TRY_WITH_RESOURCES: 
            case WHILE_LOOP: {
                return false;
            }
        }
        return true;
    }

    private LineBuffer linesWrap(Instruction insn, OperatorPrecedence precedence) {
        return this.wrap(this.lines(insn), this.getPrecedence(insn).isLowerThan(precedence));
    }

    private LineBuffer wrap(LineBuffer buffer, boolean wrap) {
        if (!wrap) {
            return buffer;
        }
        return buffer.prepend("(").append(")");
    }

    private BlockContainer getOwningContainer(Instruction insn) {
        while (!(insn.getParent() instanceof BlockContainer)) {
            insn = insn.getParent();
        }
        return (BlockContainer)insn.getParent();
    }

    private AbstractLoop getOwningLoop(Instruction insn) {
        while (!(insn.getParent() instanceof AbstractLoop)) {
            insn = insn.getParent();
        }
        return (AbstractLoop)insn.getParent();
    }

    @Nullable
    private Instruction getNaturalExit(BlockContainer container) {
        Instruction lastInsn = (Instruction)((Block)container.blocks.last()).instructions.last();
        if (lastInsn instanceof Leave && ((Leave)lastInsn).getTargetContainer() == container) {
            if (container.getParent() instanceof AbstractLoop) {
                return null;
            }
            return lastInsn;
        }
        if (lastInsn instanceof Continue && ((Continue)lastInsn).getLoop().getBody() == container) {
            return lastInsn;
        }
        if (lastInsn instanceof Return && ((Return)lastInsn).getMethod().getBody() == container) {
            return lastInsn;
        }
        return null;
    }

    private OperatorPrecedence getPrecedence(Instruction insn) {
        switch (insn.opcode) {
            case BINARY: {
                Binary binary = (Binary)insn;
                if (LdcMatching.matchNegation(binary) != null) {
                    return OperatorPrecedence.UNARY;
                }
                switch (binary.getOp()) {
                    case SUB: 
                    case ADD: {
                        return OperatorPrecedence.ADDITIVE;
                    }
                    case MUL: 
                    case DIV: 
                    case REM: {
                        return OperatorPrecedence.MULTIPLICATIVE;
                    }
                    case AND: {
                        return OperatorPrecedence.BITWISE_AND;
                    }
                    case OR: {
                        return OperatorPrecedence.BITWISE_INCLUSIVE_OR;
                    }
                    case XOR: {
                        return OperatorPrecedence.BITWISE_EXCLUSIVE_OR;
                    }
                    case SHIFT_LEFT: 
                    case SHIFT_RIGHT: 
                    case LOGICAL_SHIFT_RIGHT: {
                        return OperatorPrecedence.SHIFT;
                    }
                }
            }
            case SWITCH: 
            case LOGIC_NOT: {
                return OperatorPrecedence.UNARY;
            }
            case COMPARISON: {
                switch (((Comparison)insn).getKind()) {
                    case EQUAL: 
                    case NOT_EQUAL: {
                        return OperatorPrecedence.EQUALITY;
                    }
                    case GREATER_THAN: 
                    case GREATER_THAN_EQUAL: 
                    case LESS_THAN: 
                    case LESS_THAN_EQUAL: {
                        return OperatorPrecedence.RELATIONAL;
                    }
                }
            }
            case INSTANCE_OF: {
                return OperatorPrecedence.RELATIONAL;
            }
            case LOGIC_AND: {
                return OperatorPrecedence.LOGIC_AND;
            }
            case LOGIC_OR: {
                return OperatorPrecedence.LOGIC_OR;
            }
            case TERNARY: {
                return OperatorPrecedence.TERNARY;
            }
            case CHECK_CAST: {
                return OperatorPrecedence.CAST;
            }
            case FIELD_REFERENCE: 
            case INVOKE: 
            case INVOKE_DYNAMIC: 
            case ARRAY_LEN: 
            case ARRAY_ELEMENT_REFERENCE: {
                return OperatorPrecedence.MEMBER_ACCESS;
            }
            case COMPOUND_ASSIGNMENT: {
                if (AssignmentMatching.matchPreInc(insn) != null) {
                    return insn.getParent().opcode == InsnOpcode.BLOCK ? OperatorPrecedence.POSTFIX_INC_DEC : OperatorPrecedence.UNARY;
                }
            }
            case STORE: {
                return OperatorPrecedence.ASSIGNMENT;
            }
            case POST_INCREMENT: {
                return OperatorPrecedence.POSTFIX_INC_DEC;
            }
        }
        return OperatorPrecedence.UNKNOWN;
    }

    public String getVariableName(LocalVariable v) {
        String name = this.variableNames.get(v);
        if (name != null) {
            return name;
        }
        boolean seen = this.importCollector.isVariableInScope(v.getName());
        name = seen ? v.getUniqueName() : v.getName();
        this.importCollector.pushVariableName(name);
        this.variableNames.put(v, name);
        return name;
    }

    public boolean requiresLabelDefinition(Leave leave) {
        if (!this.supportsNaturalBreakKeyword(leave.getTargetContainer())) {
            return true;
        }
        MethodDecl func = this.peekFunc();
        if (leave.getTargetContainer() == func.getBody()) {
            return false;
        }
        BlockContainer container = this.getOwningContainer(leave);
        while (leave.getTargetContainer() != container) {
            if (this.supportsNaturalBreakKeyword(container)) {
                return true;
            }
            container = this.getOwningContainer(container);
        }
        return false;
    }

    private boolean supportsNaturalBreakKeyword(BlockContainer container) {
        return container.getParent().opcode == InsnOpcode.SWITCH || container.getParent() instanceof AbstractLoop;
    }

    public boolean requiresLabelDefinition(Continue cont) {
        return this.getOwningLoop(cont) != cont.getLoop();
    }

    public LineBuffer blockHeader(BlockContainer container) {
        if (this.requiresLabelDefinition(container)) {
            return LineBuffer.of(container.getEntryPoint().getName() + ":");
        }
        return LineBuffer.of();
    }

    public boolean requiresLabelDefinition(BlockContainer container) {
        AbstractLoop loop;
        if (!this.supportsNaturalBreakKeyword(container) && container.getLeaveCount() == 1 && this.isFallthroughExit((Leave)container.getLeaves().only())) {
            return false;
        }
        if (container.getParent() instanceof AbstractLoop && (loop = (AbstractLoop)container.getParent()).getContinues().anyMatch(this::requiresLabelDefinition)) {
            return true;
        }
        return container.getLeaves().anyMatch(this::requiresLabelDefinition);
    }

    private boolean isFallthroughExit(Leave leave) {
        return ((Block)leave.getTargetContainer().blocks.last()).getLastChild() == leave;
    }

    private MethodDecl peekFunc() {
        return Objects.requireNonNull(this.functionStack.peek());
    }

    private ClassDecl peekClass() {
        return Objects.requireNonNull(this.classStack.peek());
    }

    @Override
    public LineBuffer visitDefault(Instruction insn, None ctx) {
        throw new UnsupportedOperationException("Unhandled visit method: " + insn.getClass().getName());
    }

    @Override
    public LineBuffer visitNop(Nop nop, None ctx) {
        if (nop.getTag() instanceof ErrorTag) {
            ErrorTag tag = (ErrorTag)nop.getTag();
            return LineBuffer.of("/*").append(tag.comment).append("*/ ").append(tag.literal);
        }
        return LineBuffer.of("nop");
    }

    @Override
    public LineBuffer visitDeadCode(DeadCode deadCode, None ctx) {
        return LineBuffer.of("/* Dead Code").join(this.lines(deadCode.getCode())).append("*/");
    }

    @Override
    public LineBuffer visitArrayElementReference(ArrayElementReference elemRef, None ctx) {
        return this.linesWrap(elemRef.getArray(), OperatorPrecedence.MEMBER_ACCESS).append("[").append(this.lines(elemRef.getIndex())).append("]");
    }

    @Override
    public LineBuffer visitArrayLen(ArrayLen arrayLen, None ctx) {
        return this.linesWrap(arrayLen.getArray(), OperatorPrecedence.MEMBER_ACCESS).append(".length");
    }

    @Override
    public LineBuffer visitAssert(Assert assertInsn, None ctx) {
        LineBuffer buffer = LineBuffer.of("assert ").append(this.lines(assertInsn.getCondition()));
        Instruction message = assertInsn.getMessage();
        if (message.opcode != InsnOpcode.NOP) {
            buffer = buffer.append(" : ").append(this.lines(message));
        }
        return buffer;
    }

    @Override
    public LineBuffer visitBlock(Block block, None ctx) {
        ImmutableList.Builder builder = ImmutableList.builder();
        boolean emitBraces = false;
        if (!block.getBranches().isEmpty()) {
            builder.add((Object)this.indent(block.getName() + ":"));
            emitBraces = true;
        }
        if (emitBraces) {
            builder.add((Object)this.indent("{"));
            this.pushScope();
        }
        Iterator<Instruction> iterator = block.instructions.iterator();
        while (iterator.hasNext()) {
            Instruction instruction = iterator.next();
            builder.addAll(this.indent((LineBuffer)this.end((LineBuffer)this.lines((Instruction)instruction), (boolean)this.shouldEnd((Instruction)instruction))).lines);
        }
        if (emitBraces) {
            this.popScope();
            builder.add((Object)this.indent("}"));
        }
        return LineBuffer.of((List<String>)builder.build());
    }

    @Override
    public LineBuffer visitBlockContainer(BlockContainer container, None ctx) {
        boolean forGoto = container.getParentOrNull() instanceof Block;
        boolean requiresBraces = container.blocks.size() != 1 || ((Block)container.blocks.first()).instructions.size() > 2 || BranchLeaveMatching.matchLeave(((Block)container.blocks.first()).getLastChild(), container) == null;
        LineBuffer buffer = LineBuffer.of();
        if (forGoto) {
            buffer = this.blockHeader(container);
            if (requiresBraces) {
                buffer = buffer.join(LineBuffer.of("{"));
                this.pushScope();
            }
        }
        boolean first = true;
        Iterator<Block> iterator = container.blocks.iterator();
        while (iterator.hasNext()) {
            Block block = iterator.next();
            if (!first) {
                buffer = buffer.add("");
            }
            first = false;
            buffer = buffer.join(this.lines(block));
        }
        if (forGoto && requiresBraces) {
            this.popScope();
            buffer = buffer.join(LineBuffer.of("}"));
        }
        return buffer;
    }

    @Override
    public LineBuffer visitBranch(Branch branch, None ctx) {
        Block targetBlock = branch.getTargetBlock();
        return LineBuffer.of("goto " + targetBlock.getName());
    }

    @Override
    public LineBuffer visitCheckCast(Cast cast, None ctx) {
        return LineBuffer.of("(" + this.importCollector.collect(cast.getType()) + ") ").append(this.linesWrap(cast.getArgument(), OperatorPrecedence.CAST));
    }

    private LineBuffer classHeader(ClassDecl classDecl, boolean isEnum) {
        ClassType clazz = classDecl.getClazz();
        Object classFlags = clazz.getAccessFlags();
        boolean isAnnotation = ((EnumBitSet)classFlags).get((AccessFlag)AccessFlag.ANNOTATION);
        boolean isInterface = ((EnumBitSet)classFlags).get((AccessFlag)AccessFlag.INTERFACE) && !isAnnotation;
        boolean isRecord = ((EnumBitSet)classFlags).get((AccessFlag)AccessFlag.RECORD);
        LineBuffer buffer = LineBuffer.of();
        if (clazz.getDeclType().isLocalOrAnonymous() && classDecl.getParentOrNull() != null && classDecl.getParent().opcode == InsnOpcode.CLASS_DECL) {
            buffer = buffer.add("// CG: Unprocessed Local/Anonymous Class");
        }
        AnnotationSupplier annotationSupplier = clazz.getAnnotationSupplier();
        buffer = buffer.join(this.importCollector.annotations(annotationSupplier.getAnnotations()));
        if (isInterface) {
            classFlags = ((EnumBitSet)classFlags).copy();
            ((EnumBitSet)classFlags).clear(AccessFlag.INTERFACE);
            ((EnumBitSet)classFlags).clear(AccessFlag.ABSTRACT);
        }
        if (isRecord) {
            classFlags = ((EnumBitSet)classFlags).copy();
            ((EnumBitSet)classFlags).clear(AccessFlag.STATIC);
            ((EnumBitSet)classFlags).clear(AccessFlag.FINAL);
        }
        buffer = buffer.add(AccessFlag.stringRep((EnumBitSet<AccessFlag>)classFlags));
        List<ClassType> permittedSubclasses = clazz.getPermittedSubclasses();
        if (!(isEnum || isAnnotation || isRecord)) {
            if (!permittedSubclasses.isEmpty()) {
                buffer = buffer.append("sealed ");
            } else if (clazz.getDirectSuperTypes().anyMatch(e -> !e.getPermittedSubclasses().isEmpty()) && !clazz.isFinal()) {
                buffer = buffer.append("non-sealed ");
            }
            buffer = isInterface ? buffer.append("interface ") : buffer.append("class ");
        }
        buffer = buffer.append(clazz.getName());
        buffer = buffer.append(this.typeParameters(clazz, annotationSupplier));
        if (isRecord) {
            buffer = buffer.append("(");
            boolean first = true;
            for (ClassDecl.RecordComponentDecl comp : classDecl.recordComponents) {
                if (!first) {
                    buffer = buffer.append(", ");
                }
                first = false;
                if (!comp.regularAnnotations.isEmpty()) {
                    buffer = buffer.append(this.importCollector.annotations(comp.regularAnnotations).joinOn(" ")).append(" ");
                }
                AType type = comp.field.getField().getType();
                if (comp.isVarargs) {
                    assert (type instanceof ArrayType);
                    assert (classDecl.recordComponents.get(classDecl.recordComponents.size() - 1) == comp);
                    type = ((ArrayType)type).getElementType();
                }
                buffer = buffer.append(this.importCollector.collect(type, comp.typeAnnotations));
                if (comp.isVarargs) {
                    buffer = buffer.append("...");
                }
                buffer = buffer.append(" ").append(comp.field.getField().getName());
            }
            buffer = buffer.append(")");
        }
        buffer = buffer.append(Character.valueOf(' '));
        ClassType superClass = clazz.getSuperClass();
        TypeAnnotationData superAnnotations = annotationSupplier.getTypeAnnotations(AnnotationSupplier.TypeAnnotationLocation.CLASS_EXTENDS, superClass);
        if (!((isEnum || isRecord || clazz.isInterface() || TypeSystem.isObject(superClass)) && superAnnotations.isEmpty())) {
            buffer = buffer.append("extends ").append(this.importCollector.collect(superClass, superAnnotations)).append(" ");
        }
        List<ClassType> interfaces = clazz.getInterfaces();
        if (!isAnnotation && !interfaces.isEmpty()) {
            buffer = buffer.append(clazz.isInterface() ? "extends " : "implements ");
            for (int i = 0; i < interfaces.size(); ++i) {
                if (i != 0) {
                    buffer = buffer.append(", ");
                }
                ClassType type = interfaces.get(i);
                TypeAnnotationData annotation = annotationSupplier.getTypeAnnotations(AnnotationSupplier.TypeAnnotationLocation.CLASS_INTERFACE, type, i);
                buffer = buffer.append(this.importCollector.collect(type, annotation));
            }
            buffer = buffer.append(" ");
        }
        if (!isEnum && !permittedSubclasses.isEmpty()) {
            buffer = buffer.append("permits ");
            for (int i = 0; i < permittedSubclasses.size(); ++i) {
                if (i != 0) {
                    buffer = buffer.append(", ");
                }
                buffer = buffer.append(this.importCollector.collect(permittedSubclasses.get(i)));
            }
            buffer = buffer.append(" ");
        }
        return buffer;
    }

    private LineBuffer visitPackageInfo(ClassDecl decl) {
        ClassType clazz = decl.getClazz();
        this.classStack.push(decl);
        this.importCollector.pushScope(clazz);
        LineBuffer buffer = this.importCollector.annotations(clazz.getAnnotationSupplier().getAnnotations());
        buffer = buffer.add("package " + clazz.getPackage() + ";");
        buffer = buffer.add("");
        List<String> imports = this.importCollector.getImports(decl);
        if (!imports.isEmpty()) {
            for (String s : imports) {
                buffer = buffer.add("import " + s + ";");
            }
        }
        this.importCollector.popScope();
        this.classStack.pop();
        return buffer;
    }

    @Override
    public LineBuffer visitClassDecl(ClassDecl classDecl, None ctx) {
        ClassType clazz = classDecl.getClazz();
        boolean isTopLevel = this.classStack.isEmpty();
        boolean isAnonymousClass = classDecl.getParentOrNull() instanceof New;
        if (isTopLevel) {
            this.importCollector.setTopLevelClass(clazz);
        }
        if (clazz.isInterface() && clazz.isSynthetic() && clazz.getName().equals("package-info")) {
            return this.visitPackageInfo(classDecl);
        }
        boolean isEnum = clazz.isEnum() && clazz.getDeclType() != ClassType.DeclType.ANONYMOUS;
        boolean isRecord = clazz.getAccessFlags().get(AccessFlag.RECORD);
        LineBuffer buffer = isAnonymousClass ? LineBuffer.of("{") : this.indent(this.classHeader(classDecl, isEnum).append("{"));
        this.classStack.push(classDecl);
        this.importCollector.pushScope(clazz);
        this.pushIndent();
        Object fields = classDecl.getFieldMembers().toImmutableList();
        if (isEnum) {
            FieldDecl decl;
            int processedEnums = 0;
            UnmodifiableIterator unmodifiableIterator = fields.iterator();
            while (unmodifiableIterator.hasNext() && this.isEnumConstant(decl = (FieldDecl)unmodifiableIterator.next())) {
                if (processedEnums != 0) {
                    buffer = buffer.append(",");
                }
                buffer = buffer.join(this.indent(this.visitEnumFieldDecl(decl)));
                ++processedEnums;
            }
            if (processedEnums != 0) {
                buffer = buffer.append(";");
            } else if (!classDecl.members.isEmpty()) {
                buffer = buffer.add(this.indent(";"));
            }
            fields = fields.subList(processedEnums, fields.size());
        }
        boolean first = true;
        for (FieldDecl field : fields) {
            if (isRecord && !field.getField().isStatic()) continue;
            if (first) {
                buffer = buffer.add("");
                first = false;
            }
            buffer = buffer.join(this.indent(this.lines(field)));
        }
        for (MethodDecl method : classDecl.getMethodMembers().toImmutableList()) {
            buffer = buffer.add("");
            buffer = buffer.join(this.indent(this.lines(method)));
        }
        for (ClassDecl inner : classDecl.getClassMembers().toImmutableList()) {
            buffer = buffer.add("");
            buffer = buffer.join(this.indent(this.lines(inner)));
        }
        this.popIndent();
        buffer = buffer.add(this.indent("}"));
        this.importCollector.popScope();
        this.classStack.pop();
        LineBuffer classTop = LineBuffer.of();
        if (isTopLevel) {
            List<String> imports;
            if (!clazz.getPackage().isEmpty()) {
                classTop = classTop.add("package " + clazz.getPackage() + ";");
                classTop = classTop.add("");
            }
            if (!(imports = this.importCollector.getImports(classDecl)).isEmpty()) {
                for (String s : imports) {
                    classTop = classTop.add("import " + s + ";");
                }
                classTop = classTop.add("");
            }
        }
        return classTop.join(buffer);
    }

    @Override
    public LineBuffer visitComparison(Comparison comparison, None ctx) {
        boolean wrapLeft = this.getPrecedence(comparison.getLeft()).isLowerThan(this.getPrecedence(comparison));
        boolean wrapRight = !this.getPrecedence(comparison).isLowerThan(this.getPrecedence(comparison.getRight()));
        return this.wrap(this.lines(comparison.getLeft()), wrapLeft).append(" " + comparison.getKind().chars + " ").append(this.wrap(this.lines(comparison.getRight()), wrapRight));
    }

    @Override
    public LineBuffer visitCompoundAssignment(CompoundAssignment comp, None ctx) {
        if (AssignmentMatching.matchPreInc(comp) != null) {
            String op;
            String string = op = comp.getOp() == BinaryOp.ADD ? "++" : "--";
            if (comp.getParent().opcode == InsnOpcode.BLOCK) {
                return this.lines(comp.getReference()).append(op);
            }
            return LineBuffer.of(op).append(this.lines(comp.getReference()));
        }
        return this.lines(comp.getReference()).append(" " + comp.getOp().chars + "= ").append(this.lines(comp.getValue()));
    }

    @Override
    public LineBuffer visitContinue(Continue cont, None ctx) {
        if (this.getNaturalExit(this.getOwningContainer(cont)) == cont) {
            return LineBuffer.of();
        }
        if (!this.requiresLabelDefinition(cont)) {
            return LineBuffer.of("continue");
        }
        return LineBuffer.of("continue " + cont.getLoop().getBody().getEntryPoint().getName());
    }

    @Override
    public LineBuffer visitDoWhileLoop(DoWhileLoop doWhileLoop, None ctx) {
        LineBuffer buffer = this.blockHeader(doWhileLoop.getBody());
        buffer = buffer.add("do {");
        this.pushScope();
        buffer = buffer.join(this.indent(this.lines(doWhileLoop.getBody())));
        this.popScope();
        buffer = buffer.add("}");
        buffer = buffer.add("while (").append(this.lines(doWhileLoop.getCondition())).append(")");
        return buffer;
    }

    private boolean isEnumConstant(FieldDecl decl) {
        ClassType parent = this.peekClass().getClazz();
        Field field = decl.getField();
        if (!field.isStatic()) {
            return false;
        }
        if (!field.getAccessFlags().get(AccessFlag.FINAL)) {
            return false;
        }
        if (!field.getType().equals(parent)) {
            return false;
        }
        New newInsn = InvokeMatching.matchNew(decl.getValue());
        if (newInsn == null) {
            return false;
        }
        if (newInsn.getResultType().equals(parent)) {
            return true;
        }
        if (!newInsn.hasAnonymousClassDeclaration()) {
            return false;
        }
        ClassDecl anonClass = newInsn.getAnonymousClassDeclaration();
        return anonClass.getClazz().getSuperClass().equals(parent);
    }

    private LineBuffer visitEnumFieldDecl(FieldDecl fieldDecl) {
        New newInsn = (New)fieldDecl.getValue();
        Field field = fieldDecl.getField();
        LineBuffer buffer = LineBuffer.of();
        List<AnnotationData> annotations = field.getAnnotationSupplier().getAnnotations();
        if (!annotations.isEmpty()) {
            buffer = buffer.join(this.importCollector.annotations(annotations));
            buffer = buffer.add("");
        }
        buffer = buffer.append(field.getName());
        if (newInsn.getArguments().anyMatch(e -> e.opcode != InsnOpcode.NOP)) {
            buffer = buffer.append(this.argList(newInsn.getArguments()));
        }
        if (newInsn.hasAnonymousClassDeclaration()) {
            buffer = buffer.append(" ").append(this.lines(newInsn.getAnonymousClassDeclaration()));
        }
        this.declaredFields.add(field.getDeclaration());
        return buffer;
    }

    @Override
    public LineBuffer visitFieldDecl(FieldDecl fieldDecl, None ctx) {
        Field field = fieldDecl.getField();
        String access = AccessFlag.stringRep(field.getAccessFlags());
        if (fieldDecl.getField().getDeclaringClass().isInterface()) {
            access = "";
        }
        AType fieldType = field.getType();
        AnnotationSupplier annotationSupplier = field.getAnnotationSupplier();
        TypeAnnotationData typeAnnotations = annotationSupplier.getTypeAnnotations(AnnotationSupplier.TypeAnnotationLocation.FIELD, fieldType);
        LineBuffer buffer = this.importCollector.annotations(annotationSupplier.getAnnotations(typeAnnotations)).add(access).append(this.importCollector.collect(fieldType, typeAnnotations)).append(" ").append(field.getName());
        if (!(fieldDecl.getValue() instanceof Nop)) {
            buffer = buffer.append(" = ").append(this.lines(fieldDecl.getValue()));
        }
        this.declaredFields.add(field.getDeclaration());
        return buffer.append(";");
    }

    @Override
    public LineBuffer visitFieldReference(FieldReference fieldRef, None ctx) {
        Field field = fieldRef.getField();
        Field fieldDecl = field.getDeclaration();
        boolean notDeclaredYet = this.classStack.peek().getClazz() == fieldDecl.getDeclaringClass() && !this.declaredFields.contains(fieldDecl);
        LineBuffer buffer = LineBuffer.of();
        if (fieldRef.getTarget().opcode == InsnOpcode.NOP) {
            ClassType type = field.getDeclaringClass();
            if (notDeclaredYet || this.importCollector.doesStaticFieldRequireQualifier(fieldRef.getTargetClassType(), field)) {
                buffer = LineBuffer.of().append(this.importCollector.collect(type)).append(".");
            }
        } else if (notDeclaredYet || fieldRef.getTarget().opcode != InsnOpcode.LOAD_THIS || this.importCollector.isFieldHidden(fieldRef.getTargetClassType(), field)) {
            buffer = this.linesWrap(fieldRef.getTarget(), OperatorPrecedence.MEMBER_ACCESS).append(".");
        }
        return buffer.append(fieldRef.getField().getName());
    }

    @Override
    public LineBuffer visitForEachLoop(ForEachLoop forEachLoop, None ctx) {
        LineBuffer buffer = LineBuffer.of();
        buffer = buffer.append(this.blockHeader(forEachLoop.getBody()));
        buffer = buffer.add("for (");
        this.pushScope();
        buffer = buffer.append(this.lines(forEachLoop.getVariable()));
        buffer = buffer.append(" : ");
        buffer = buffer.append(this.lines(forEachLoop.getIterator()));
        buffer = buffer.append(") {");
        buffer = buffer.join(this.indent(this.lines(forEachLoop.getBody())));
        this.popScope();
        buffer = buffer.add("}");
        return buffer;
    }

    @Override
    public LineBuffer visitForLoop(ForLoop forLoop, None ctx) {
        LineBuffer buffer = LineBuffer.of();
        buffer = buffer.append(this.blockHeader(forLoop.getBody()));
        buffer = buffer.add("for (");
        this.pushScope();
        if (forLoop.getInitializer().opcode != InsnOpcode.NOP) {
            buffer = buffer.append(this.lines(forLoop.getInitializer()));
        }
        buffer = buffer.append("; ");
        buffer = buffer.append(this.lines(forLoop.getCondition())).append("; ");
        buffer = buffer.append(this.argList("", forLoop.getIncrement().instructions, ""));
        buffer = buffer.append(") {");
        buffer = buffer.join(this.indent(this.lines(forLoop.getBody())));
        this.popScope();
        buffer = buffer.add("}");
        return buffer;
    }

    private LineBuffer printLambdaDecl(MethodDecl methodDecl, List<ParameterVariable> parameterVars) {
        this.functionStack.push(methodDecl);
        this.importCollector.pushVariableScope();
        assert (methodDecl.hasBody());
        BlockContainer body = methodDecl.getBody();
        boolean expressionLambda = body.blocks.size() == 1 && ((Block)body.blocks.first()).instructions.first() instanceof Return;
        this.declaredVariables.addAll(parameterVars);
        parameterVars.forEach(e -> this.importCollector.pushVariableName(e.getName()));
        LineBuffer buffer = LineBuffer.of();
        buffer = parameterVars.size() != 1 ? buffer.append("(").append(FastStream.of(parameterVars).map(this::getVariableName).join(", ")).append(")") : buffer.append(this.getVariableName(parameterVars.get(0)));
        buffer = buffer.append(" -> ");
        if (expressionLambda) {
            Instruction insn = ((Instruction)((Block)body.blocks.first()).instructions.first()).getFirstChild();
            buffer = insn.opcode == InsnOpcode.NOP ? buffer.append("{ }") : buffer.append(this.lines(insn));
        } else {
            buffer = buffer.append("{");
            this.pushIndent();
            buffer = buffer.join(this.lines(body));
            this.popIndent();
            buffer = buffer.add("}");
        }
        this.importCollector.popVariableScope();
        this.functionStack.pop();
        return buffer;
    }

    @Override
    public LineBuffer visitMethodDecl(MethodDecl methodDecl, None ctx) {
        boolean isLambda;
        LinkedList parameterVars = methodDecl.parameters.filter(e -> !e.isImplicit()).toLinkedList();
        boolean bl = isLambda = !(methodDecl.getParent() instanceof ClassDecl);
        if (isLambda) {
            return this.printLambdaDecl(methodDecl, parameterVars);
        }
        ClassDecl cDecl = (ClassDecl)methodDecl.getParent();
        this.functionStack.push(methodDecl);
        this.importCollector.pushVariableScope();
        Method method = methodDecl.getMethod();
        AType returnType = method.getReturnType();
        boolean isAnnotationClass = method.getDeclaringClass().getAccessFlags().get(AccessFlag.ANNOTATION);
        boolean isStaticInitializer = method.getName().equals("<clinit>");
        AnnotationSupplier annotationSupplier = method.getAnnotationSupplier();
        TypeAnnotationData methodReturnTypeAnnotations = annotationSupplier.getTypeAnnotations(AnnotationSupplier.TypeAnnotationLocation.METHOD_RETURN, returnType);
        LineBuffer buffer = LineBuffer.of();
        buffer = buffer.join(this.importCollector.annotations(annotationSupplier.getAnnotations(methodReturnTypeAnnotations)));
        buffer = buffer.add("");
        if (!isStaticInitializer) {
            List<ReferenceType> exceptions;
            if (!isAnnotationClass) {
                String access = AccessFlag.stringRep(method.getAccessFlags());
                if (method.getDeclaringClass().isInterface()) {
                    if (method.isAbstract()) {
                        access = access.replace("public abstract ", "");
                    }
                    access = method.isStatic() ? access.replace("public ", "") : access.replace("public", "default");
                }
                buffer = buffer.append(access);
            }
            String typeParam = this.typeParameters(method, annotationSupplier);
            buffer = buffer.append(typeParam);
            if (!typeParam.isEmpty()) {
                buffer = buffer.append(" ");
            }
            if (method.isConstructor()) {
                buffer = buffer.append(method.getDeclaringClass().getName());
            } else {
                buffer = buffer.append(this.importCollector.collect(returnType, methodReturnTypeAnnotations));
                buffer = buffer.append(" ");
                buffer = buffer.append(method.getName());
            }
            if (cDecl.canonicalCtor == methodDecl) {
                for (ParameterVariable variable : parameterVars) {
                    this.declaredVariables.add(variable);
                    this.importCollector.pushVariableName(variable.getName());
                }
            } else {
                TypeAnnotationData receiverTypeAnnotations;
                ClassType receiverType;
                buffer = buffer.append("(");
                boolean first = true;
                ClassType declaringClass = method.getDeclaringClass();
                ClassType enclosingClass = declaringClass.getEnclosingClass().orElse(null);
                ClassType classType = method.isConstructor() ? (enclosingClass != null ? TypeSystem.makeThisType(enclosingClass) : null) : (receiverType = TypeSystem.makeThisType(declaringClass));
                if (receiverType != null && !(receiverTypeAnnotations = annotationSupplier.getTypeAnnotations(AnnotationSupplier.TypeAnnotationLocation.METHOD_RECEIVER, receiverType)).isEmpty()) {
                    if (method.isConstructor()) {
                        ClassType outer = declaringClass.getEnclosingClass().orElseThrow(SneakyUtils.notPossible());
                        buffer = buffer.append(this.importCollector.collect((AType)receiverType, receiverTypeAnnotations)).append(" ").append(this.importCollector.collect(outer.getDeclaration())).append(".");
                    } else {
                        buffer = buffer.append(this.importCollector.collect((AType)receiverType, receiverTypeAnnotations)).append(" ");
                    }
                    buffer = buffer.append("this");
                    first = false;
                }
                List<Parameter> parameters = method.getParameters();
                for (int i = 0; i < parameterVars.size(); ++i) {
                    TypeAnnotationData typeAnnotations;
                    ParameterVariable variable = (ParameterVariable)parameterVars.get(i);
                    this.declaredVariables.add(variable);
                    this.importCollector.pushVariableName(variable.getName());
                    if (!first) {
                        buffer = buffer.append(", ");
                    }
                    first = false;
                    AType type = variable.getType();
                    Parameter parameter = parameters.get(variable.pIndex);
                    buffer = buffer.append(AccessFlag.stringRep(parameter.getFlags()));
                    AnnotationSupplier pAnnSupplier = parameter.getAnnotationSupplier();
                    List<AnnotationData> annotations = pAnnSupplier.getAnnotations(typeAnnotations = pAnnSupplier.getTypeAnnotations(AnnotationSupplier.TypeAnnotationLocation.PARAMETER, type, parameter.getFormalIdx()));
                    if (!annotations.isEmpty()) {
                        buffer = buffer.append(this.importCollector.annotations(annotations).joinOn(" "));
                        buffer = buffer.append(" ");
                    }
                    if (i == parameterVars.size() - 1 && type instanceof ArrayType && method.getAccessFlags().get(AccessFlag.VARARGS)) {
                        buffer = buffer.append(this.importCollector.collect(((ArrayType)type).getElementType(), typeAnnotations.step(TypeAnnotationData.Target.ARRAY_ELEMENT)));
                        buffer = buffer.append("...");
                    } else {
                        buffer = buffer.append(this.importCollector.collect(type, typeAnnotations));
                    }
                    buffer = buffer.append(" ");
                    buffer = buffer.append(this.getVariableName(variable));
                }
                buffer = buffer.append(")");
            }
            if (!(exceptions = method.getExceptions()).isEmpty()) {
                buffer = buffer.append(" throws ");
                for (int i = 0; i < exceptions.size(); ++i) {
                    if (i != 0) {
                        buffer = buffer.append(", ");
                    }
                    ReferenceType type = exceptions.get(i);
                    buffer = buffer.append(this.importCollector.collect(type, annotationSupplier.getTypeAnnotations(AnnotationSupplier.TypeAnnotationLocation.METHOD_THROWS, type, i)));
                }
            }
        } else {
            buffer = buffer.append("static");
        }
        if (!method.isAbstract()) {
            buffer = buffer.append(" {");
            this.pushIndent();
            buffer = buffer.join(this.lines(methodDecl.getBody()));
            this.popIndent();
            buffer = buffer.add("}");
        } else {
            Object defaultAnnotationValue = method.getDefaultAnnotationValue();
            if (isAnnotationClass && defaultAnnotationValue != null) {
                buffer = buffer.append(" default ").append(this.importCollector.annotationValue(defaultAnnotationValue));
            }
            buffer = buffer.append(";");
        }
        this.importCollector.popVariableScope();
        this.functionStack.pop();
        return buffer;
    }

    @Override
    public LineBuffer visitIfInstruction(IfInstruction ifInsn, None ctx) {
        LineBuffer buffer = LineBuffer.of("if (").append(this.lines(ifInsn.getCondition())).append(") {");
        this.pushScope();
        if (ifInsn.getTrueInsn().opcode != InsnOpcode.NOP) {
            buffer = buffer.join(this.indent(this.end(this.lines(ifInsn.getTrueInsn()), this.shouldEnd(ifInsn.getTrueInsn()))));
        }
        this.popScope();
        if (ifInsn.getFalseInsn().opcode != InsnOpcode.NOP) {
            Instruction falseInsn = ifInsn.getFalseInsn();
            if (falseInsn.opcode == InsnOpcode.BLOCK && falseInsn.getChildren().onlyOrDefault() != null && falseInsn.getFirstChild().opcode == InsnOpcode.IF) {
                buffer = buffer.add(this.indent("} else ")).append(this.lines(ifInsn.getFalseInsn().getFirstChild()));
                return buffer;
            }
            buffer = buffer.add(this.indent("} else {"));
            this.pushScope();
            buffer = buffer.join(this.indent(this.end(this.lines(ifInsn.getFalseInsn()), this.shouldEnd(ifInsn.getFalseInsn()))));
            this.popScope();
        }
        buffer = buffer.add(this.indent("}"));
        return buffer;
    }

    @Override
    public LineBuffer visitPostIncrement(PostIncrement postIncrement, None ctx) {
        return this.lines(postIncrement.getReference()).append(postIncrement.isPositive() ? "++" : "--");
    }

    @Override
    public LineBuffer visitInstanceOf(InstanceOf instanceOf, None ctx) {
        return this.linesWrap(instanceOf.getArgument(), OperatorPrecedence.RELATIONAL).append(" instanceof " + this.importCollector.collect(instanceOf.getType()));
    }

    @Override
    public LineBuffer visitInvoke(Invoke invoke, None ctx) {
        boolean isCtorCall;
        MethodDecl currentFunc = this.functionStack.peek();
        ClassDecl currentClass = this.peekClass();
        LineBuffer buffer = LineBuffer.of();
        Method method = invoke.getMethod();
        boolean bl = isCtorCall = method.getName().equals("<init>") && currentFunc != null && currentFunc.getMethod().isConstructor();
        if (invoke.getKind() == Invoke.InvokeKind.STATIC) {
            if (invoke.explicitTypeArgs || this.importCollector.doesStaticMethodRequireQualifier(invoke.getTargetClassType(), method.getName())) {
                buffer = LineBuffer.of(this.importCollector.collect(method.getDeclaringClass())).append(".");
            }
        } else if (!isCtorCall) {
            ClassType targetClass = invoke.getTargetClassType().getDeclaration();
            if (invoke.getKind() == Invoke.InvokeKind.SPECIAL && currentClass.getClazz() != targetClass) {
                if (invoke.getTarget().opcode != InsnOpcode.LOAD_THIS) {
                    buffer = this.linesWrap(invoke.getTarget(), OperatorPrecedence.MEMBER_ACCESS).append(".");
                } else if (targetClass.isInterface()) {
                    buffer = buffer.append(this.importCollector.collect(targetClass)).append(".");
                }
                buffer = buffer.append("super").append(".");
            } else if (invoke.explicitTypeArgs || invoke.getTarget().opcode != InsnOpcode.LOAD_THIS || this.importCollector.isMethodHidden(((LoadThis)invoke.getTarget()).getType().getDeclaration(), method.getName())) {
                buffer = this.linesWrap(invoke.getTarget(), OperatorPrecedence.MEMBER_ACCESS);
                buffer = buffer.append(".");
            }
        }
        if (isCtorCall) {
            if (invoke.getTarget().opcode != InsnOpcode.LOAD_THIS) {
                buffer = this.lines(invoke.getTarget()).append(".");
            }
            buffer = InvokeMatching.matchConstructorInvokeSpecial(invoke, currentClass.getClazz()) != null ? buffer.append("this") : buffer.append("super");
        } else {
            if (method instanceof ParameterizedMethod && invoke.explicitTypeArgs) {
                buffer = this.appendTypeArguments(((ParameterizedMethod)method).getTypeArguments(), buffer);
            }
            buffer = buffer.append(method.getName());
        }
        buffer = buffer.append(this.argList(invoke.getArguments()));
        return buffer;
    }

    @Override
    public LineBuffer visitMethodReference(MethodReference methodReference, None ctx) {
        LineBuffer buffer;
        Method method = methodReference.getMethod();
        Instruction target = methodReference.getTarget();
        if (target.opcode == InsnOpcode.NOP) {
            if (method.isConstructor()) {
                return LineBuffer.of(this.importCollector.collect(method.getDeclaringClass()) + "::new");
            }
            buffer = LineBuffer.of(this.importCollector.collect(methodReference.getTargetClassType()) + "::");
        } else {
            buffer = this.linesWrap(target, OperatorPrecedence.MEMBER_ACCESS).append("::");
        }
        if (method instanceof ParameterizedMethod && methodReference.explicitTypeArgs) {
            buffer = this.appendTypeArguments(((ParameterizedMethod)method).getTypeArguments(), buffer);
        }
        return buffer.append(method.getName());
    }

    @Override
    public LineBuffer visitLdcBoolean(LdcBoolean ldcBoolean, None ctx) {
        return LineBuffer.of(ldcBoolean.getValue() ? "true" : "false");
    }

    @Override
    public LineBuffer visitLdcChar(LdcChar ldcChar, None ctx) {
        return LineBuffer.of("'" + EscapeUtils.escapeChar(ldcChar.getValue()) + "'");
    }

    @Override
    public LineBuffer visitLdcClass(LdcClass ldcClass, None ctx) {
        return LineBuffer.of(this.importCollector.collect(ldcClass.getType()) + ".class");
    }

    @Override
    public LineBuffer visitLdcNumber(LdcNumber ldcNumber, None ctx) {
        String number = ldcNumber.getValue().toString();
        String prettyNumber = this.prettyPrintNumber(ldcNumber.getValue());
        boolean requiresSuffix = this.shouldPrintSuffix(ldcNumber, number);
        if (ldcNumber.getValue() instanceof Double) {
            return LineBuffer.of(requiresSuffix ? number : prettyNumber);
        }
        if (ldcNumber.getValue() instanceof Float) {
            return LineBuffer.of(prettyNumber).append(requiresSuffix ? "F" : "");
        }
        if (ldcNumber.getValue() instanceof Long) {
            return LineBuffer.of(number).append(requiresSuffix ? "L" : "");
        }
        return LineBuffer.of(number);
    }

    private String prettyPrintNumber(Number number) {
        String str = number.toString();
        if (!str.endsWith(".0")) {
            return str;
        }
        return str.substring(0, str.length() - 2);
    }

    private boolean shouldPrintSuffix(LdcNumber ldc, String numberStr) {
        AType type = ldc.getResultType();
        if (type == PrimitiveType.FLOAT && numberStr.toUpperCase().contains("E")) {
            return true;
        }
        Instruction us = ldc;
        Instruction parent = ldc.getParentOrNull();
        if (LdcMatching.matchNegation(parent) != null) {
            us = parent;
            parent = parent.getParent();
        }
        if (parent == null || parent.opcode != InsnOpcode.BINARY) {
            return true;
        }
        Binary binary = (Binary)parent;
        if (binary.getRight() == us) {
            return this.requiresSuffix(binary.getLeft(), type, ldc.getValue()) || LdcMatching.matchLdcNumber(this.unwrapNegation(binary.getLeft())) != null;
        }
        assert (binary.getLeft() == us);
        return this.requiresSuffix(binary.getRight(), type, ldc.getValue());
    }

    private boolean requiresSuffix(Instruction otherSide, AType ourType, Number ldc) {
        if (otherSide.getResultType() != ourType) {
            return true;
        }
        if (ourType == PrimitiveType.LONG && (ldc.longValue() > Integer.MAX_VALUE || ldc.longValue() < Integer.MIN_VALUE)) {
            return true;
        }
        return ourType == PrimitiveType.FLOAT && LdcMatching.matchLdcNumber(otherSide) == null && (float)ldc.intValue() != ldc.floatValue();
    }

    private Instruction unwrapNegation(Instruction insn) {
        Instruction nValue = LdcMatching.matchNegation(insn);
        return nValue != null ? nValue : insn;
    }

    @Override
    public LineBuffer visitLdcNull(LdcNull ldcNull, None ctx) {
        return LineBuffer.of("null");
    }

    @Override
    public LineBuffer visitLdcString(LdcString ldcString, None ctx) {
        return LineBuffer.of("\"" + EscapeUtils.escapeChars(ldcString.getValue()) + "\"");
    }

    @Override
    public LineBuffer visitLeave(Leave leave, None ctx) {
        if (this.getNaturalExit(this.getOwningContainer(leave)) == leave) {
            return LineBuffer.of();
        }
        if (!this.requiresLabelDefinition(leave)) {
            return LineBuffer.of("break");
        }
        return LineBuffer.of("break " + leave.getTargetContainer().getEntryPoint().getName());
    }

    @Override
    public LineBuffer visitLoad(Load load, None ctx) {
        return this.lines(load.getReference());
    }

    @Override
    public LineBuffer visitLoadThis(LoadThis loadThis, None ctx) {
        ClassDecl currentClass = this.peekClass();
        if (loadThis.getType().getDeclaration() != currentClass.getClazz()) {
            return LineBuffer.of(loadThis.getType().getName() + ".this");
        }
        return LineBuffer.of("this");
    }

    @Override
    public LineBuffer visitLocalReference(LocalReference localRef, None ctx) {
        LineBuffer buffer = LineBuffer.of();
        if (this.declaredVariables.add(localRef.variable)) {
            this.localRefDeclarations.add(localRef);
            AType type = localRef.variable.getType();
            AnnotationSupplier annotationSupplier = localRef.variable.getAnnotationSupplier();
            buffer = buffer.append(this.importCollector.collect(type, annotationSupplier.getTypeAnnotations(AnnotationSupplier.TypeAnnotationLocation.LOCAL_VARIABLE, type))).append(" ");
        }
        return buffer.append(this.getVariableName(localRef.variable));
    }

    @Override
    public LineBuffer visitLogicAnd(LogicAnd logicAnd, None ctx) {
        return this.linesWrap(logicAnd.getLeft(), OperatorPrecedence.LOGIC_AND).append(" && ").append(this.linesWrap(logicAnd.getRight(), OperatorPrecedence.LOGIC_AND));
    }

    @Override
    public LineBuffer visitLogicNot(LogicNot logicNot, None ctx) {
        return LineBuffer.of("!").append(this.linesWrap(logicNot.getArgument(), OperatorPrecedence.UNARY));
    }

    @Override
    public LineBuffer visitLogicOr(LogicOr logicOr, None ctx) {
        return this.linesWrap(logicOr.getLeft(), OperatorPrecedence.LOGIC_OR).append(" || ").append(this.linesWrap(logicOr.getRight(), OperatorPrecedence.LOGIC_OR));
    }

    @Override
    public LineBuffer visitMonitor(Monitor monitor, None ctx) {
        throw new NotImplementedException("TODO");
    }

    @Override
    public LineBuffer visitNewArray(NewArray newArray, None ctx) {
        LineBuffer buffer = LineBuffer.of();
        if (!newArray.isInitializer) {
            AType rootElementType = newArray.getType();
            int numDims = 0;
            while (rootElementType instanceof ArrayType) {
                rootElementType = rootElementType.getElementType();
                ++numDims;
            }
            buffer = buffer.append("new ").append(this.importCollector.collect(rootElementType));
            InstructionCollection<Instruction> indices = newArray.getIndices();
            Iterator<Instruction> iterator = indices.iterator();
            while (iterator.hasNext()) {
                Instruction index = iterator.next();
                buffer = buffer.append("[").append(this.lines(index)).append("]");
            }
            for (int i = indices.size(); i < numDims; ++i) {
                buffer = buffer.append("[]");
            }
        } else {
            if (!this.isArrayInitializerTypeImplicit(newArray)) {
                buffer = buffer.append("new ").append(this.importCollector.collect(newArray.getType())).append(" ");
            }
            buffer = buffer.append(this.argList("{ ", newArray.getValues(), " }"));
        }
        return buffer;
    }

    private boolean isArrayInitializerTypeImplicit(NewArray newArray) {
        Store store;
        Instruction parent = newArray.getParent();
        AType parentType = parent.getResultType();
        if (parent.opcode == InsnOpcode.NEW_ARRAY) {
            return ((ArrayType)parentType).getElementType().equals(newArray.getType());
        }
        if (parent.opcode == InsnOpcode.STORE && this.localRefDeclarations.contains((store = (Store)parent).getReference())) {
            return parentType.equals(newArray.getType());
        }
        return parent.opcode == InsnOpcode.FIELD_DECL && parentType.equals(newArray.getType());
    }

    @Override
    public LineBuffer visitNew(New newInsn, None ctx) {
        Method method = newInsn.getMethod();
        IndexedInstructionCollection<Instruction> arguments = newInsn.getArguments();
        boolean printedTarget = false;
        Instruction target = newInsn.getTarget();
        LineBuffer buffer = LineBuffer.of();
        if (target != null && target.opcode != InsnOpcode.LOAD_THIS) {
            buffer = buffer.append(this.linesWrap(target, OperatorPrecedence.MEMBER_ACCESS)).append(".");
            printedTarget = true;
        }
        TypeAnnotationData extendsAnnotations = TypeAnnotationData.EMPTY;
        ClassType type = newInsn.getResultType();
        if (newInsn.hasAnonymousClassDeclaration()) {
            LinkedList superTypes = type.getDirectSuperTypes().toLinkedList();
            type = (ClassType)superTypes.get(superTypes.size() - 1);
        }
        if (newInsn.explicitTypeArgs && method instanceof ParameterizedMethod) {
            buffer = this.appendTypeArguments(((ParameterizedMethod)method).getTypeArguments(), buffer);
        }
        buffer = buffer.append("new ").append(this.importCollector.collect(type, extendsAnnotations, printedTarget, !newInsn.explicitClassTypeArgs && !newInsn.hasAnonymousClassDeclaration()));
        buffer = buffer.append(this.argList((FastStream<Instruction>)arguments.filter(e -> e != target)));
        if (newInsn.hasAnonymousClassDeclaration()) {
            buffer = buffer.append(" ").append(this.lines(newInsn.getAnonymousClassDeclaration()));
        }
        return buffer;
    }

    @Override
    public LineBuffer visitNewObject(NewObject newObject, None ctx) {
        return LineBuffer.of("/* TODO CG: NewObject*/ ").append("new ").append(this.importCollector.collect(newObject.getType()) + "();");
    }

    @Override
    public LineBuffer visitReturn(Return ret, None ctx) {
        if (ret.getValue() instanceof Nop && this.getNaturalExit(this.getOwningContainer(ret)) == ret) {
            return LineBuffer.of();
        }
        if (ret.getValue() instanceof Nop) {
            return LineBuffer.of("return");
        }
        return LineBuffer.of("return ").append(this.lines(ret.getValue()));
    }

    @Override
    public LineBuffer visitBinary(Binary binary, None ctx) {
        boolean wrapRight;
        OperatorPrecedence precedence = this.getPrecedence(binary);
        boolean bl = wrapRight = !precedence.isLowerThan(this.getPrecedence(binary.getRight()));
        if (LdcMatching.matchNegation(binary) != null) {
            return LineBuffer.of("-").append(this.wrap(this.lines(binary.getRight()), wrapRight));
        }
        return this.linesWrap(binary.getLeft(), precedence).append(" " + binary.getOp().chars + " ").append(this.wrap(this.lines(binary.getRight()), wrapRight));
    }

    @Override
    public LineBuffer visitStore(Store store, None ctx) {
        return this.lines(store.getReference()).append(" = ").append(this.linesWrap(store.getValue(), OperatorPrecedence.ASSIGNMENT));
    }

    @Override
    public LineBuffer visitSwitch(Switch switchInsn, None ctx) {
        LineBuffer buffer = this.blockHeader(switchInsn.getBody());
        buffer = buffer.join(LineBuffer.of("switch (").append(this.lines(switchInsn.getValue())).append(") {"));
        this.pushScope();
        buffer = buffer.join(this.lines(switchInsn.getBody()));
        this.popScope();
        buffer = buffer.add("}");
        return buffer;
    }

    @Override
    public LineBuffer visitSwitchTable(SwitchTable switchTable, None ctx) {
        LineBuffer buffer = LineBuffer.of();
        Iterator<SwitchTable.SwitchSection> iterator = switchTable.sections.iterator();
        while (iterator.hasNext()) {
            Instruction child = iterator.next();
            buffer = buffer.join(this.lines(child));
        }
        return buffer;
    }

    @Override
    public LineBuffer visitSwitchSection(SwitchTable.SwitchSection switchSection, None ctx) {
        LineBuffer buffer = LineBuffer.of();
        Iterator<Instruction> iterator = switchSection.values.iterator();
        while (iterator.hasNext()) {
            Instruction value = iterator.next();
            if (value instanceof Nop) {
                buffer = buffer.join(LineBuffer.of("default:"));
                continue;
            }
            buffer = buffer.join(LineBuffer.of("case ").append(this.printSwitchValue(value)).append(":"));
        }
        this.pushIndent();
        buffer = buffer.join(this.indent(this.end(this.lines(switchSection.getBody()), this.shouldEnd(switchSection.getBody()))));
        this.popIndent();
        return buffer;
    }

    private LineBuffer printSwitchValue(Instruction value) {
        FieldReference ref = LoadStoreMatching.matchFieldRef(value);
        if (ref == null) {
            return this.lines(value);
        }
        ClassType clazz = ref.getField().getDeclaringClass();
        if (ref.getField().getType() != clazz) {
            return this.lines(value);
        }
        if (!clazz.isEnum()) {
            return this.lines(value);
        }
        return LineBuffer.of(ref.getField().getName());
    }

    @Override
    public LineBuffer visitSynchronized(Synchronized synchInsn, None ctx) {
        LineBuffer buffer = LineBuffer.of(this.indent("synchronized(")).append(this.lines(synchInsn.getVariable())).append(") {");
        this.pushScope();
        buffer = buffer.join(this.lines(synchInsn.getBody()));
        this.popScope();
        buffer = buffer.add(this.indent("}"));
        return buffer;
    }

    @Override
    public LineBuffer visitTernary(Ternary ternary, None ctx) {
        return this.linesWrap(ternary.getCondition(), OperatorPrecedence.TERNARY).append(" ? ").append(this.linesWrap(ternary.getTrueInsn(), OperatorPrecedence.TERNARY)).append(" : ").append(this.linesWrap(ternary.getFalseInsn(), OperatorPrecedence.TERNARY));
    }

    @Override
    public LineBuffer visitThrow(Throw throwInsn, None ctx) {
        return LineBuffer.of("throw ").append(this.lines(throwInsn.getArgument()));
    }

    private LineBuffer tryHeader(TryInstruction tryInsn, String header) {
        return this.blockHeader(tryInsn.getTryBody()).join(LineBuffer.of(header));
    }

    @Override
    public LineBuffer visitTryCatch(TryCatch tryCatch, None ctx) {
        LineBuffer buffer = this.tryHeader(tryCatch, "try {");
        this.pushScope();
        buffer = buffer.join(this.lines(tryCatch.getTryBody()));
        this.popScope();
        buffer = buffer.add("}");
        Iterator<TryCatch.TryCatchHandler> iterator = tryCatch.handlers.iterator();
        while (iterator.hasNext()) {
            TryCatch.TryCatchHandler handler = iterator.next();
            buffer = buffer.append(this.lines(handler));
        }
        return buffer;
    }

    @Override
    public LineBuffer visitTryCatchHandler(TryCatch.TryCatchHandler catchHandler, None ctx) {
        LineBuffer buffer = LineBuffer.of(" catch (");
        this.pushScope();
        buffer = buffer.append(this.lines(catchHandler.getVariable()));
        buffer = buffer.append(") {");
        buffer = buffer.join(this.lines(catchHandler.getBody()));
        this.popScope();
        buffer = buffer.add("}");
        return buffer;
    }

    @Override
    public LineBuffer visitTryFinally(TryFinally tryFinally, None ctx) {
        LineBuffer buffer = this.tryHeader(tryFinally, "try {");
        this.pushScope();
        buffer = buffer.join(this.lines(tryFinally.getTryBody()));
        this.popScope();
        buffer = buffer.add("} finally {");
        this.pushScope();
        buffer = buffer.join(this.lines(tryFinally.getFinallyBody()));
        this.popScope();
        buffer = buffer.add("}");
        return buffer;
    }

    @Override
    public LineBuffer visitTryWithResources(TryWithResources tryWithResources, None ctx) {
        this.pushScope();
        LineBuffer buffer = this.tryHeader(tryWithResources, "try (").append(this.lines(tryWithResources.getResource())).append(") {").join(this.lines(tryWithResources.getTryBody())).add("}");
        this.popScope();
        return buffer;
    }

    @Override
    public LineBuffer visitWhileLoop(WhileLoop whileLoop, None ctx) {
        LineBuffer buffer = this.blockHeader(whileLoop.getBody());
        buffer = buffer.add("while (").append(this.lines(whileLoop.getCondition())).append(") {");
        this.pushScope();
        buffer = buffer.join(this.indent(this.lines(whileLoop.getBody())));
        this.popScope();
        buffer = buffer.add("}");
        return buffer;
    }

    @Override
    public LineBuffer visitYield(Yield yield, None ctx) {
        return LineBuffer.of("yield ").append(this.lines(yield.getValue()));
    }
}

