package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.Parameter;
import org.jetbrains.annotations.Nullable;

/**
 * Created by covers1624 on 22/11/21.
 */
public class ParameterVariable extends LocalVariable {

    public final Parameter parameter;
    /**
     * Defines the index in the FunctionInstruction arguments this Parameter is defined.
     * <code>-1</code> defines the 'this' parameter.
     */
    public final int pIndex;

    private boolean isImplicit;

    public ParameterVariable(Parameter parameter, AType type, @Nullable String genericSignature, int index, String name, int pIndex) {
        super(VariableKind.PARAMETER, type, genericSignature, index, name);
        this.parameter = parameter;
        this.pIndex = pIndex;
    }

    public boolean isImplicit() {
        return isImplicit;
    }

    public void makeImplicit() {
        isImplicit = true;
    }
}
