package net.covers1624.coffeegrinder.bytecode.transform;

import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;

/**
 * Holder class for various arguments for {@link MethodTransformer#transform}.
 * <p>
 * Created by covers1624 on 21/2/21.
 */
public class MethodTransformContext extends TransformContextBase {

    private final MethodDecl function;

    public MethodTransformContext(TransformContextBase other, MethodDecl function) {
        super(other);
        this.function = function;
    }

    public MethodTransformContext(MethodTransformContext other) {
        this(other, other.function);
    }

    // Debug evaluation and breakpoints.
    private boolean currentMethodMatches(String name) {
        return function.getMethod().getName().equals(name);
    }
}
