package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.*;
import net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching;
import net.covers1624.coffeegrinder.bytecode.transform.StatementTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.StatementTransformer;
import net.covers1624.quack.collection.FastStream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

import java.util.*;

/**
 * Created by covers1624 on 8/2/24.
 */
public class SwitchExpressions implements StatementTransformer {

    @Override
    public void transform(Instruction statement, StatementTransformContext ctx) {
        Switch sSwitch = matchSwitch(statement);
        if (sSwitch == null) return;
        BlockContainer switchBody = sSwitch.getBody();
        // STORE(s_1, ...)
        // LEAVE L0_switch
        Set<LocalVariable> candidateVars = new HashSet<>();
        for (Leave leave : switchBody.getLeaves()) {
            Store store = LoadStoreMatching.matchStore(leave.getPrevSiblingOrNull());
            if (store == null) return;

            // Local var must be stack slot.
            LocalReference r = LoadStoreMatching.matchLocalRef(store.getReference());
            if (r == null) return;
            if (r.variable.getKind() != LocalVariable.VariableKind.STACK_SLOT) return;
            candidateVars.add(r.variable);
        }
        LocalVariable stackVar = FastStream.of(candidateVars).onlyOrDefault();
        // We did not find exactly one distinct var, not switch expression.
        if (stackVar == null) return;
        if (stackVar.getLoadCount() != 1) return;

        ctx.pushStep("Produce switch expression.");
        Switch newSwitch = new Switch(sSwitch.getValue(), switchBody, stackVar.getType());
        for (Leave leave : switchBody.getLeaves().toList()) {
            Store store = (Store) leave.getPrevSibling();
            leave.replaceWith(new Yield(newSwitch, store.getValue()).withOffsets(leave));
            store.remove();
        }
        sSwitch.replaceWith(new Store(new LocalReference(stackVar), newSwitch));
        ctx.popStep();
    }

    // TODO move this somewhere else..
    @Contract ("null->null")
    public static @Nullable Switch matchSwitch(@Nullable Instruction insn) {
        if (insn == null || insn.opcode != InsnOpcode.SWITCH) return null;

        return (Switch) insn;
    }
}
