package net.covers1624.coffeegrinder.bytecode.transform.transformers.generics;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import net.covers1624.coffeegrinder.bytecode.insns.AbstractInvoke;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.type.*;
import net.covers1624.quack.collection.FastStream;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * Created by covers1624 on 29/8/22.
 */
public class InferenceSolution implements TypeSubstitutions.TypeParamMapper {

    public final Map<TypeParameter, ReferenceType> map;
    public final AType retType;

    public final List<Pair<MethodDecl, ReferenceType>> lambdaTypes;
    public final Map<AbstractInvoke, InferenceSolution> nested;
    @Nullable
    public final String failureReason;
    public final boolean hasRawArgs;
    public final boolean explicit;
    @Nullable
    public final ReferenceType polyFailed;

    private InferenceSolution(Map<TypeParameter, ReferenceType> map, AType retType, List<Pair<MethodDecl, ReferenceType>> lambdaTypes, Map<AbstractInvoke, InferenceSolution> nested, @Nullable String failureReason, boolean hasRawArgs, boolean explicit, @Nullable ReferenceType polyFailed) {
        this.map = map;
        this.retType = retType;
        this.lambdaTypes = lambdaTypes;
        this.nested = nested;
        this.failureReason = failureReason;
        this.hasRawArgs = hasRawArgs;
        this.explicit = explicit;
        this.polyFailed = polyFailed;
    }

    public static InferenceSolution failure(String reason) {
        return new InferenceSolution(ImmutableMap.of(), PrimitiveType.VOID, ImmutableList.of(), ImmutableMap.of(), reason, false, false, null);
    }

    public static InferenceSolution success(Map<TypeParameter, ReferenceType> map, AType retType, Map<AbstractInvoke, InferenceSolution> nested, List<Pair<MethodDecl, ReferenceType>> lambdaTypes, boolean hasRawArgs) {
        return new InferenceSolution(map, retType, lambdaTypes, nested, null, hasRawArgs, false, null);
    }

    @Override
    public ReferenceType mapParam(TypeParameter param) {
        return map.getOrDefault(param, param);
    }

    public InferenceSolution makeExplicit() {
        return new InferenceSolution(
                FastStream.of(map.entrySet())
                        .toImmutableMap(Map.Entry::getKey, e -> BoundSet.makeRepresentable(e.getValue())),
                retType,
                lambdaTypes, nested,
                failureReason,
                hasRawArgs,
                true,
                null
        );
    }

    public InferenceSolution polyFailed(ReferenceType targetType) {
        return new InferenceSolution(
                map,
                retType,
                lambdaTypes, nested,
                failureReason,
                false,
                explicit,
                targetType
        );
    }

    public boolean hasFailed() {
        return failureReason != null;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof InferenceSolution)) return false;
        InferenceSolution other = (InferenceSolution) obj;

        return Objects.equals(failureReason, other.failureReason) &&
                map.equals(other.map) &&
                nested.equals(other.nested);
    }
}
