/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.testengine.testcase.target;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Objects;
import net.covers1624.coffeegrinder.bytecode.DebugPrintOptions;
import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.insns.ClassDecl;
import net.covers1624.coffeegrinder.source.AstSourceVisitor;
import net.covers1624.coffeegrinder.source.JavaSourceVisitor;
import net.covers1624.coffeegrinder.source.LineBuffer;
import net.covers1624.coffeegrinder.testengine.api.Target;
import net.covers1624.coffeegrinder.testengine.testcase.target.TargetStepDescriptor;
import net.covers1624.coffeegrinder.testengine.testcase.target.TestCaseDescriptor;
import net.covers1624.coffeegrinder.testengine.testcase.util.OutputPath;
import net.covers1624.coffeegrinder.type.TypeResolver;
import net.covers1624.quack.collection.FastStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.function.Executable;
import org.junit.platform.engine.UniqueId;

public class SourceTargetStepDescriptor
extends TargetStepDescriptor {
    public SourceTargetStepDescriptor(UniqueId parentId) {
        super(parentId, Target.SOURCE);
    }

    @Override
    public void execute(TestCaseDescriptor testDescriptor) throws Throwable {
        if (testDescriptor.classInsn == null && testDescriptor.root.updateLibraryDefs) {
            return;
        }
        ClassDecl clazz = Objects.requireNonNull(testDescriptor.classInsn, "Expected ClassDecl to exist.");
        String ast = SourceTargetStepDescriptor.emitAst(clazz);
        testDescriptor.source = SourceTargetStepDescriptor.emitSource(clazz, testDescriptor.typeResolver());
        Assertions.assertAll((Executable[])new Executable[]{() -> SourceTargetStepDescriptor.compare(testDescriptor.outputAst, ast, testDescriptor), () -> SourceTargetStepDescriptor.compare(testDescriptor.outputSource, testDescriptor.source, testDescriptor)});
    }

    private static String emitAst(ClassDecl classInsn) {
        DebugPrintOptions opts = new DebugPrintOptions(false, false, false, true, true, true, false);
        AstSourceVisitor astVisitor = new AstSourceVisitor(opts);
        LineBuffer ast = (LineBuffer)classInsn.accept((InsnVisitor)astVisitor);
        LinkedList lines = FastStream.of((Iterable)astVisitor.getImports(classInsn)).map(e -> "import " + e).toLinkedList();
        if (!lines.isEmpty()) {
            lines.add("");
        }
        lines.addAll(ast.lines);
        return String.join((CharSequence)System.lineSeparator(), lines);
    }

    private static String emitSource(ClassDecl classInsn, TypeResolver typeResolver) {
        JavaSourceVisitor visitor = new JavaSourceVisitor(typeResolver);
        ImmutableList sourceLines = ((LineBuffer)classInsn.accept((InsnVisitor)visitor)).lines;
        return String.join((CharSequence)System.lineSeparator(), (Iterable<? extends CharSequence>)sourceLines);
    }

    private static void compare(OutputPath.Entry output, String result, TestCaseDescriptor testDescriptor) throws IOException {
        String previous = output.readOrNull();
        if (testDescriptor.root.updateOutput) {
            if (previous == null || !previous.equals(result)) {
                output.write(result);
            }
            return;
        }
        if (previous == null) {
            Assertions.assertFalse((boolean)testDescriptor.outputMandatory, (String)"Test requires output. Please re-run in update mode.");
            return;
        }
        Assertions.assertEquals((Object)previous, (Object)result);
    }
}

