/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.testengine.testcase;

import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.covers1624.coffeegrinder.testengine.testcase.DecompileTestCaseEngine;
import net.covers1624.coffeegrinder.testengine.testcase.TestCase;
import net.covers1624.coffeegrinder.testengine.testcase.target.TestCaseDescriptor;
import net.covers1624.coffeegrinder.testengine.testcase.util.InputPath;
import net.covers1624.coffeegrinder.testengine.testcase.util.LibraryTestCaseDef;
import net.covers1624.coffeegrinder.testengine.testcase.util.OutputPath;
import net.covers1624.coffeegrinder.util.jvm.JVMUtils;
import net.covers1624.coffeegrinder.util.resolver.ClassResolver;
import net.covers1624.jdkutils.JavaInstall;
import net.covers1624.quack.collection.FastStream;
import net.javasauce.compilerserver.Compiler;
import org.jetbrains.annotations.Nullable;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;
import org.junit.platform.engine.support.hierarchical.OpenTest4JAwareThrowableCollector;

public class TestCaseEngineDescriptor
extends EngineDescriptor {
    private static final Gson GSON = new Gson();
    private static final Type LIST_STRING_TYPE = new TypeToken<List<String>>(){}.getType();
    private final DecompileTestCaseEngine decompileTestCaseEngine;
    private final ConfigurationParameters config;
    private final List<TestCase> tests = new ArrayList<TestCase>();
    public final boolean updateLibraryDefs;
    public final boolean updateOutput;
    public final String mandatoryOutputPackage;
    public final InputPath inputClassPaths;
    public final OutputPath outputAstPath;
    public final OutputPath outputSourcePath;
    @Nullable
    public final OutputPath outputCompileErrorPath;
    @Nullable
    public final OutputPath outputRoundTripDiffsPath;
    public final List<String> javacArgs;
    public final boolean terseTestAborts;
    public final Compiler compiler;
    public final ClassResolver classResolver;
    @Nullable
    public LibraryTestCaseDef libraryDefs;

    public TestCaseEngineDescriptor(DecompileTestCaseEngine decompileTestCaseEngine, UniqueId uniqueId, ConfigurationParameters config) {
        super(uniqueId, "CoffeeGrinder Test Cases");
        this.decompileTestCaseEngine = decompileTestCaseEngine;
        this.config = config;
        this.updateLibraryDefs = config.getBoolean("coffeegrinder.testcases.library.update_defs").orElse(false);
        this.updateOutput = config.getBoolean("coffeegrinder.test.update").orElse(false);
        this.mandatoryOutputPackage = config.get("coffeegrinder.test.mandatory_output_package").orElse("");
        List<Path> libraryPaths = this.getPathsConfig("coffeegrinder.test.libraries");
        Path inputPath = this.getPathConfig("coffeegrinder.test.classes");
        this.inputClassPaths = InputPath.of(inputPath, "class", true);
        this.outputAstPath = new OutputPath(this.getPathConfig("coffeegrinder.test.output"), "ast");
        this.outputSourcePath = new OutputPath(this.getPathConfig("coffeegrinder.test.output"), "java");
        this.outputCompileErrorPath = this.optionalOutputPath("coffeegrinder.test.compile_error_output", "java.txt");
        this.outputRoundTripDiffsPath = this.optionalOutputPath("coffeegrinder.test.rt_diff_output", "class.diff");
        this.javacArgs = (List)GSON.fromJson(config.get("coffeegrinder.test.javac_args").orElse("[]"), LIST_STRING_TYPE);
        this.terseTestAborts = config.getBoolean("coffeegrinder.test.terse_aborts").orElse(false);
        JavaInstall javaInstall = JVMUtils.getJavaInstall(this.getPathConfig("coffeegrinder.test.java_under_test"));
        Path javaExecutable = JavaInstall.getJavaExecutable((Path)javaInstall.javaHome, (boolean)true);
        try {
            LinkedHashSet<Path> compileClasspath = new LinkedHashSet<Path>(libraryPaths);
            compileClasspath.add(inputPath);
            this.compiler = Compiler.of(javaExecutable, compileClasspath);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to start CompilerServer for " + javaExecutable, e);
        }
        this.classResolver = new ClassResolver();
        this.classResolver.addResolvers(JVMUtils.getTargetJREClasspath(javaInstall));
        for (Path path : libraryPaths) {
            this.classResolver.addResolver(path);
        }
        this.classResolver.setTarget(inputPath);
    }

    public TestCaseDescriptor addTestCase(TestCase testCase) {
        this.tests.add(testCase);
        TestCaseDescriptor descriptor = new TestCaseDescriptor(this.getUniqueId(), testCase, this);
        this.addChild((TestDescriptor)descriptor);
        return descriptor;
    }

    public void execute(EngineExecutionListener listener) {
        OpenTest4JAwareThrowableCollector collector = new OpenTest4JAwareThrowableCollector();
        listener.executionStarted((TestDescriptor)this);
        ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Test Executor %d").build());
        ArrayList futures = new ArrayList();
        for (TestDescriptor testDescriptor : this.getChildren()) {
            TestCaseDescriptor testChild = (TestCaseDescriptor)testDescriptor;
            futures.add(executor.submit(() -> testChild.execute(listener)));
        }
        for (Future future : futures) {
            collector.execute(future::get);
        }
        collector.execute(executor::shutdown);
        collector.execute(this.compiler::close);
        collector.execute(() -> {
            this.outputAstPath.removeUnusedFiles();
            this.outputSourcePath.removeUnusedFiles();
            if (this.outputCompileErrorPath != null) {
                this.outputCompileErrorPath.removeUnusedFiles();
            }
            if (this.outputRoundTripDiffsPath != null) {
                this.outputRoundTripDiffsPath.removeUnusedFiles();
            }
        });
        listener.executionFinished((TestDescriptor)this, collector.toTestExecutionResult());
    }

    public List<TestCase> tests() {
        return Collections.unmodifiableList(this.tests);
    }

    @Nullable
    protected OutputPath optionalOutputPath(String prop, String ext) {
        Path path = this.getOptionalPathConfig(prop);
        if (path == null) {
            return null;
        }
        return new OutputPath(path, ext);
    }

    @Nullable
    public Path getOptionalPathConfig(String prop) {
        return this.config.get(prop, x$0 -> Paths.get(x$0, new String[0])).orElse(null);
    }

    protected Path getPathConfig(String prop) {
        return (Path)this.config.get(prop, x$0 -> Paths.get(x$0, new String[0])).orElseThrow(() -> new IllegalStateException("Missing required configuration option '" + prop + "'."));
    }

    protected List<Path> getPathsConfig(String prop) {
        String str = (String)this.config.get(prop).orElseThrow(() -> new IllegalStateException("Missing required configuration option '" + prop + "'."));
        return FastStream.of((Object[])str.split(File.pathSeparator)).map(x$0 -> Paths.get(x$0, new String[0])).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).distinct().toList();
    }
}

