/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.IndexedInstructionCollection;
import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.bytecode.InstructionSlot;
import net.covers1624.coffeegrinder.bytecode.insns.AbstractInvoke;
import net.covers1624.coffeegrinder.bytecode.insns.ClassDecl;
import net.covers1624.coffeegrinder.bytecode.insns.Nop;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.Method;
import net.covers1624.coffeegrinder.type.TypeSystem;
import net.covers1624.coffeegrinder.util.EnumBitSet;
import org.jetbrains.annotations.Nullable;

public class New
extends AbstractInvoke {
    private ClassType type;
    private Method ctor;
    public boolean explicitClassTypeArgs;
    public boolean hasEnclosingScopeInstanceParam;
    private final IndexedInstructionCollection<Instruction> arguments;
    private final InstructionSlot<Instruction> anonymousClassDeclaration = new InstructionSlot(this);

    public New(ClassType type, Method ctor, Iterable<Instruction> args) {
        this(type, ctor, args, new Nop());
    }

    private New(ClassType type, Method ctor, Iterable<Instruction> args, Instruction anonClassDeclaration) {
        super(InsnOpcode.NEW);
        this.type = type;
        this.ctor = ctor;
        this.arguments = new IndexedInstructionCollection(this);
        this.arguments.setValues(args);
        this.anonymousClassDeclaration.set(anonClassDeclaration);
        assert (type.getDeclaration() == ctor.getDeclaringClass());
    }

    @Override
    public ClassType getResultType() {
        return this.type;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.MAY_THROW.toSet();
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitNew(this, ctx);
    }

    public void setAnonymousClassDeclaration(ClassDecl anonymousClassDeclaration) {
        this.anonymousClassDeclaration.set(anonymousClassDeclaration);
    }

    public boolean hasAnonymousClassDeclaration() {
        return this.anonymousClassDeclaration.get().opcode == InsnOpcode.CLASS_DECL;
    }

    public ClassDecl getAnonymousClassDeclaration() {
        assert (this.hasAnonymousClassDeclaration());
        return (ClassDecl)this.anonymousClassDeclaration.get();
    }

    @Override
    public Method getMethod() {
        return this.ctor;
    }

    @Override
    public IndexedInstructionCollection<Instruction> getArguments() {
        return this.arguments;
    }

    public void setType(ClassType type) {
        this.type = type;
    }

    public void setMethod(Method ctor) {
        this.ctor = ctor;
        this.setType(ctor.getDeclaringClass());
    }

    @Nullable
    public Instruction getTarget() {
        if (!TypeSystem.isConstructedViaTargetInstance(this.type)) {
            return null;
        }
        return this.arguments.get(this.hasEnclosingScopeInstanceParam ? 1 : 0);
    }
}

