/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.covers1624.coffeegrinder.bytecode.AccessFlag;
import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.SimpleInsnVisitor;
import net.covers1624.coffeegrinder.bytecode.insns.Binary;
import net.covers1624.coffeegrinder.bytecode.insns.BinaryOp;
import net.covers1624.coffeegrinder.bytecode.insns.Cast;
import net.covers1624.coffeegrinder.bytecode.insns.ClassDecl;
import net.covers1624.coffeegrinder.bytecode.insns.FieldReference;
import net.covers1624.coffeegrinder.bytecode.insns.LdcNumber;
import net.covers1624.coffeegrinder.bytecode.insns.Load;
import net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching;
import net.covers1624.coffeegrinder.bytecode.transform.ClassTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.ClassTransformer;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.Field;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.type.TypeResolver;
import net.covers1624.coffeegrinder.util.None;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

public class NumericConstants
extends SimpleInsnVisitor<None>
implements ClassTransformer {
    private static final Type MATH;
    private static final Type INTEGER;
    private static final Type LONG;
    private static final Type FLOAT;
    private static final Type DOUBLE;
    private static final Map<Object, Function<NumericConstants, Instruction>> REPLACEMENTS;
    private final ClassType intClass;
    private final ClassType longClass;
    private final ClassType floatClass;
    private final ClassType doubleClass;
    private final Field piField;
    private final Field eField;

    private static void addAngle(int angle) {
        double piD = Math.PI;
        float piF = (float)Math.PI;
        double aD = angle;
        float aF = angle;
        REPLACEMENTS.putIfAbsent(piD / aD, e -> NumericConstants.div(NumericConstants.loadField(e.piField), NumericConstants.ldc(aD)));
        REPLACEMENTS.putIfAbsent(aD / piD, e -> NumericConstants.div(NumericConstants.ldc(aD), NumericConstants.loadField(e.piField)));
        REPLACEMENTS.putIfAbsent(Float.valueOf(piF / aF), e -> NumericConstants.div(NumericConstants.d2f(NumericConstants.loadField(e.piField)), NumericConstants.ldc(Float.valueOf(aF))));
        REPLACEMENTS.putIfAbsent(Float.valueOf(aF / piF), e -> NumericConstants.div(NumericConstants.ldc(Float.valueOf(aF)), NumericConstants.d2f(NumericConstants.loadField(e.piField))));
        REPLACEMENTS.putIfAbsent(aD * piD, e -> NumericConstants.mul(NumericConstants.ldc(aD), NumericConstants.loadField(e.piField)));
        REPLACEMENTS.putIfAbsent(Float.valueOf(aF * piF), e -> NumericConstants.mul(NumericConstants.ldc(Float.valueOf(aF)), NumericConstants.d2f(NumericConstants.loadField(e.piField))));
    }

    public NumericConstants(TypeResolver typeResolver) {
        ClassType mathClass = Objects.requireNonNull(typeResolver.resolveClass(MATH));
        this.intClass = Objects.requireNonNull(typeResolver.resolveClass(INTEGER));
        this.longClass = Objects.requireNonNull(typeResolver.resolveClass(LONG));
        this.floatClass = Objects.requireNonNull(typeResolver.resolveClass(FLOAT));
        this.doubleClass = Objects.requireNonNull(typeResolver.resolveClass(DOUBLE));
        this.piField = Objects.requireNonNull(mathClass.resolveField("PI", Type.DOUBLE_TYPE));
        this.eField = Objects.requireNonNull(mathClass.resolveField("E", Type.DOUBLE_TYPE));
    }

    @Override
    public void transform(ClassDecl cInsn, ClassTransformContext ctx) {
        if (cInsn.getClazz().getDeclType() != ClassType.DeclType.TOP_LEVEL) {
            return;
        }
        cInsn.accept(this);
    }

    @Override
    public None visitLdcNumber(LdcNumber ldc, None ctx) {
        Instruction replacement = this.getReplacement(ldc.getRawValue());
        if (replacement == null) {
            return NONE;
        }
        if (ldc.getParent().opcode == InsnOpcode.SWITCH_SECTION) {
            FieldReference ref = LoadStoreMatching.matchLoadFieldRef(replacement);
            if (ref == null) {
                return NONE;
            }
            if (!ref.getField().isStatic() || !ref.getField().getAccessFlags().get(AccessFlag.FINAL)) {
                return NONE;
            }
            replacement = ref;
        }
        ldc.replaceWith(replacement);
        return NONE;
    }

    @Nullable
    public Instruction getReplacement(Number number) {
        Function<NumericConstants, Instruction> repl = REPLACEMENTS.get(number);
        if (repl == null) {
            return null;
        }
        return repl.apply(this);
    }

    private static Instruction loadField(ClassType clazz, String name, Type desc) {
        return NumericConstants.loadField(clazz.resolveField(name, desc));
    }

    private static Instruction loadField(@Nullable Field field) {
        assert (field != null);
        assert (field.isStatic() && field.getAccessFlags().get(AccessFlag.FINAL));
        return new Load(new FieldReference(field));
    }

    private static Instruction negate(Instruction insn) {
        if (insn instanceof Binary) {
            Binary binary = (Binary)insn;
            binary.setLeft(NumericConstants.negate(binary.getLeft()));
            return binary;
        }
        if (insn instanceof Cast) {
            Cast cast = (Cast)insn;
            assert (cast.getType() == PrimitiveType.FLOAT);
            assert (cast.getArgument().getResultType() == PrimitiveType.DOUBLE);
            return NumericConstants.d2f(NumericConstants.negate(cast.getArgument()));
        }
        LdcNumber number = insn.getResultType() == PrimitiveType.FLOAT ? NumericConstants.ldc(Float.valueOf(0.0f)) : NumericConstants.ldc(0.0);
        return new Binary(BinaryOp.SUB, number, insn);
    }

    private static Instruction d2f(Instruction insn) {
        return new Cast(insn, PrimitiveType.FLOAT);
    }

    private static Instruction div(Instruction left, Instruction right) {
        return new Binary(BinaryOp.DIV, left, right);
    }

    private static Instruction mul(Instruction left, Instruction right) {
        return new Binary(BinaryOp.MUL, left, right);
    }

    private static LdcNumber ldc(Number n) {
        return new LdcNumber(n);
    }

    static {
        int[] angles;
        MATH = Type.getType(Math.class);
        INTEGER = Type.getType(Integer.class);
        LONG = Type.getType(Long.class);
        FLOAT = Type.getType(Float.class);
        DOUBLE = Type.getType(Double.class);
        REPLACEMENTS = new HashMap<Object, Function<NumericConstants, Instruction>>();
        double piD = Math.PI;
        float piF = (float)Math.PI;
        REPLACEMENTS.put(piD, e -> NumericConstants.loadField(e.piField));
        REPLACEMENTS.put(Float.valueOf(piF), e -> NumericConstants.d2f(NumericConstants.loadField(e.piField)));
        REPLACEMENTS.put(Math.E, e -> NumericConstants.loadField(e.eField));
        for (int i = 1; i <= 10; ++i) {
            NumericConstants.addAngle(i);
        }
        for (int angle : angles = new int[]{30, 45, 60, 90, 180, 270, 360}) {
            NumericConstants.addAngle(angle);
        }
        for (int a = 1; a <= 10; ++a) {
            double d = a;
            float aF = a;
            for (int b = 1; b <= 10; ++b) {
                if (a == 1 && b == 1) continue;
                double bD = b;
                float bF = b;
                REPLACEMENTS.putIfAbsent(d * piD / bD, e -> NumericConstants.div(NumericConstants.mul(NumericConstants.ldc(aD), NumericConstants.loadField(e.piField)), NumericConstants.ldc(bD)));
                REPLACEMENTS.putIfAbsent(Float.valueOf(aF * piF / bF), e -> NumericConstants.div(NumericConstants.mul(NumericConstants.ldc(Float.valueOf(aF)), NumericConstants.d2f(NumericConstants.loadField(e.piField))), NumericConstants.ldc(Float.valueOf(bF))));
            }
        }
        for (int n = 1; n <= 10; ++n) {
            double d = n;
            float nF = n;
            for (int d2 : new int[]{3, 7, 9}) {
                if (n % d2 == 0) continue;
                double dD = d2;
                float dF = d2;
                REPLACEMENTS.putIfAbsent(d / dD, e -> NumericConstants.div(NumericConstants.ldc(nD), NumericConstants.ldc(Float.valueOf(dF))));
                REPLACEMENTS.putIfAbsent(Float.valueOf(nF / dF), e -> NumericConstants.div(NumericConstants.ldc(Float.valueOf(nF)), NumericConstants.ldc(Float.valueOf(dF))));
            }
        }
        for (Map.Entry entry : new LinkedList<Map.Entry<Object, Function<NumericConstants, Instruction>>>(REPLACEMENTS.entrySet())) {
            Object n = entry.getKey();
            if (n instanceof Double) {
                REPLACEMENTS.putIfAbsent(-((Double)n).doubleValue(), e -> NumericConstants.negate((Instruction)((Function)entry.getValue()).apply(e)));
                continue;
            }
            REPLACEMENTS.putIfAbsent(Float.valueOf(-((Float)n).floatValue()), e -> NumericConstants.negate((Instruction)((Function)entry.getValue()).apply(e)));
        }
        REPLACEMENTS.put(Integer.MIN_VALUE, e -> NumericConstants.loadField(e.intClass, "MIN_VALUE", Type.INT_TYPE));
        REPLACEMENTS.put(Integer.MAX_VALUE, e -> NumericConstants.loadField(e.intClass, "MAX_VALUE", Type.INT_TYPE));
        REPLACEMENTS.put(Long.MIN_VALUE, e -> NumericConstants.loadField(e.longClass, "MIN_VALUE", Type.LONG_TYPE));
        REPLACEMENTS.put(Long.MAX_VALUE, e -> NumericConstants.loadField(e.longClass, "MAX_VALUE", Type.LONG_TYPE));
        REPLACEMENTS.put(Float.valueOf(Float.MIN_VALUE), e -> NumericConstants.loadField(e.floatClass, "MIN_VALUE", Type.FLOAT_TYPE));
        REPLACEMENTS.put(Float.valueOf(Float.MAX_VALUE), e -> NumericConstants.loadField(e.floatClass, "MAX_VALUE", Type.FLOAT_TYPE));
        REPLACEMENTS.put(Double.MIN_VALUE, e -> NumericConstants.loadField(e.doubleClass, "MIN_VALUE", Type.DOUBLE_TYPE));
        REPLACEMENTS.put(Double.MAX_VALUE, e -> NumericConstants.loadField(e.doubleClass, "MAX_VALUE", Type.DOUBLE_TYPE));
        REPLACEMENTS.put(Float.valueOf(Float.POSITIVE_INFINITY), e -> NumericConstants.loadField(e.floatClass.resolveField("POSITIVE_INFINITY", Type.FLOAT_TYPE)));
        REPLACEMENTS.put(Float.valueOf(Float.NEGATIVE_INFINITY), e -> NumericConstants.loadField(e.floatClass.resolveField("NEGATIVE_INFINITY", Type.FLOAT_TYPE)));
        REPLACEMENTS.put(Float.valueOf(Float.MIN_NORMAL), e -> NumericConstants.loadField(e.floatClass.resolveField("MIN_NORMAL", Type.FLOAT_TYPE)));
        REPLACEMENTS.put(Float.valueOf(Float.NaN), e -> NumericConstants.loadField(e.floatClass.resolveField("NaN", Type.FLOAT_TYPE)));
        REPLACEMENTS.put(Double.POSITIVE_INFINITY, e -> NumericConstants.loadField(e.doubleClass.resolveField("POSITIVE_INFINITY", Type.DOUBLE_TYPE)));
        REPLACEMENTS.put(Double.NEGATIVE_INFINITY, e -> NumericConstants.loadField(e.doubleClass.resolveField("NEGATIVE_INFINITY", Type.DOUBLE_TYPE)));
        REPLACEMENTS.put(Double.MIN_NORMAL, e -> NumericConstants.loadField(e.doubleClass.resolveField("MIN_NORMAL", Type.DOUBLE_TYPE)));
        REPLACEMENTS.put(Double.NaN, e -> NumericConstants.loadField(e.doubleClass.resolveField("NaN", Type.DOUBLE_TYPE)));
    }
}

