/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.type;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.covers1624.coffeegrinder.bytecode.AccessFlag;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.CapturedTypeVar;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.Field;
import net.covers1624.coffeegrinder.type.Method;
import net.covers1624.coffeegrinder.type.ReferenceType;
import net.covers1624.coffeegrinder.type.TypeParameter;
import net.covers1624.coffeegrinder.type.TypeSubstitutions;
import net.covers1624.coffeegrinder.type.TypeSystem;
import net.covers1624.coffeegrinder.type.WildcardType;
import net.covers1624.coffeegrinder.util.EnumBitSet;
import net.covers1624.coffeegrinder.util.Util;
import net.covers1624.quack.collection.ColUtils;
import net.covers1624.quack.collection.FastStream;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

public final class ParameterizedClass
extends ClassType
implements TypeSubstitutions.TypeParamMapper {
    @Nullable
    private final ParameterizedClass outer;
    private final ClassType unboundClass;
    private final List<ReferenceType> arguments;
    private final Supplier<ClassType> superClass;
    private final Supplier<List<ClassType>> interfaces;
    private final Supplier<List<Field>> fields;
    private final Supplier<List<Method>> methods;

    public ParameterizedClass(@Nullable ParameterizedClass outer, ClassType unboundClass, List<ReferenceType> arguments) {
        this.outer = outer;
        assert (unboundClass.getTypeParameters().size() == arguments.size() || arguments.isEmpty());
        assert (unboundClass.getDeclaration() == unboundClass);
        assert (outer != null == TypeSystem.needsOuterParameterization(unboundClass));
        this.unboundClass = unboundClass;
        this.arguments = arguments;
        this.superClass = Util.singleMemoize(() -> TypeSubstitutions.subst(unboundClass.getSuperClass(), (TypeSubstitutions.TypeMapper)this));
        this.interfaces = Util.singleMemoize(() -> FastStream.of(unboundClass.getInterfaces()).map(e -> TypeSubstitutions.subst(e, (TypeSubstitutions.TypeMapper)this)).toImmutableList());
        this.fields = Util.singleMemoize(() -> FastStream.of(unboundClass.getFields()).map(e -> TypeSubstitutions.applyOwnerParameterization(this, e)).toImmutableList());
        this.methods = Util.singleMemoize(() -> FastStream.of(unboundClass.getMethods()).map(e -> TypeSubstitutions.applyOwnerParameterization(this, e)).toImmutableList());
    }

    @Override
    public ReferenceType mapParam(TypeParameter param) {
        if (param.getOwner() == this.unboundClass) {
            if (!this.arguments.isEmpty()) {
                return this.arguments.get(param.getIndex());
            }
            return param;
        }
        return this.outer != null ? this.outer.mapParam(param) : param;
    }

    public ParameterizedClass capture() {
        class Capture
        extends CapturedTypeVar {
            private ReferenceType upper;

            public Capture(TypeParameter orig, WildcardType wildcard) {
                super(orig, wildcard);
                this.upper = TypeSystem.objectType(orig);
            }

            @Override
            public ReferenceType getUpperBound() {
                return this.upper;
            }

            @Override
            public Capture map(TypeSubstitutions.TypeMapper map) {
                ParameterizedClass mapped = (ParameterizedClass)TypeSubstitutions.subst(ParameterizedClass.this, map);
                if (mapped.equals(ParameterizedClass.this)) {
                    return this;
                }
                return (Capture)derivedCaptures.computeIfAbsent(mapped, ParameterizedClass::capture).arguments.get(this.orig.getIndex());
            }

            @Override
            public boolean mentions(ReferenceType type) {
                if (super.mentions(type)) {
                    return true;
                }
                return this.orig.mentions(type) || ParameterizedClass.this.mentions(type);
            }
        }
        ParameterizedClass outerCaptured;
        ParameterizedClass parameterizedClass = outerCaptured = this.outer != null ? this.outer.capture() : null;
        if (outerCaptured == this.outer && !ColUtils.anyMatch(this.arguments, e -> e instanceof WildcardType)) {
            return this;
        }
        final HashMap derivedCaptures = new HashMap();
        ArrayList<ReferenceType> fresh = new ArrayList<ReferenceType>(this.arguments.size());
        for (int i = 0; i < this.arguments.size(); ++i) {
            ReferenceType typeArg = this.arguments.get(i);
            if (typeArg instanceof WildcardType) {
                fresh.add(new Capture(this.unboundClass.getTypeParameters().get(i), (WildcardType)typeArg));
                continue;
            }
            fresh.add(typeArg);
        }
        ParameterizedClass capture = new ParameterizedClass(outerCaptured, this.unboundClass, fresh);
        for (ReferenceType freshTypeArg : fresh) {
            if (!(freshTypeArg instanceof Capture)) continue;
            Capture c = (Capture)freshTypeArg;
            c.upper = TypeSystem.glbJavac(c.wildcard.getUpperBound(), TypeSubstitutions.subst(c.orig.getUpperBound(), (TypeSubstitutions.TypeMapper)capture));
            c.upper = TypeSystem.capture(c.upper);
        }
        return capture;
    }

    public List<ReferenceType> getTypeArguments() {
        return this.arguments;
    }

    @Override
    public ClassType getSuperClass() {
        return this.superClass.get();
    }

    @Override
    public List<ClassType> getInterfaces() {
        return this.interfaces.get();
    }

    @Override
    public List<ClassType> getNestedClasses() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Field> getFields() {
        return this.fields.get();
    }

    @Override
    public List<Method> getMethods() {
        return this.methods.get();
    }

    @Override
    public ClassType.DeclType getDeclType() {
        return this.unboundClass.getDeclType();
    }

    @Override
    public String getPackage() {
        return this.unboundClass.getPackage();
    }

    @Override
    public EnumBitSet<AccessFlag> getAccessFlags() {
        return this.unboundClass.getAccessFlags();
    }

    @Override
    public Optional<ClassType> getEnclosingClass() {
        return this.outer != null ? Optional.of(this.outer) : this.unboundClass.getEnclosingClass();
    }

    @Override
    public Optional<Method> getEnclosingMethod() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Type getDescriptor() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return this.unboundClass.getName();
    }

    @Override
    public ClassType asRaw() {
        return this.unboundClass.asRaw();
    }

    @Override
    public ClassType getDeclaration() {
        return this.unboundClass;
    }

    @Nullable
    public ParameterizedClass getOuter() {
        return this.outer;
    }

    @Override
    public List<TypeParameter> getTypeParameters() {
        if (!this.arguments.isEmpty()) {
            throw new UnsupportedOperationException();
        }
        return this.unboundClass.getTypeParameters();
    }

    public boolean isFullyParameterized() {
        return this.getTypeArguments().size() == this.unboundClass.getTypeParameters().size();
    }

    @Override
    public boolean mentions(ReferenceType type) {
        return super.mentions(type) || ColUtils.anyMatch(this.getTypeArguments(), e -> e.mentions(type));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ParameterizedClass)) {
            return false;
        }
        ParameterizedClass other = (ParameterizedClass)obj;
        if (this.getDeclaration() != other.getDeclaration()) {
            return false;
        }
        if (this.getOuter() != null && !this.getOuter().equals(Objects.requireNonNull(other.getOuter()))) {
            return false;
        }
        List<ReferenceType> args1 = this.getTypeArguments();
        List<ReferenceType> args2 = other.getTypeArguments();
        for (int i = 0; i < args1.size(); ++i) {
            if (args1.get(i).equals(args2.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.outer != null ? this.outer.hashCode() : 0;
        result = 31 * result + this.unboundClass.hashCode();
        result = 31 * result + this.arguments.hashCode();
        return result;
    }

    @Override
    public String getFullName() {
        String args = "<" + FastStream.of(this.arguments).map(AType::getFullName).join(", ") + ">";
        return this.unboundClass.getFullName() + args;
    }
}

