/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.bytecode.InstructionSlot;
import net.covers1624.coffeegrinder.bytecode.insns.Reference;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.ArrayType;
import net.covers1624.coffeegrinder.util.EnumBitSet;

public class ArrayElementReference
extends Reference {
    private final InstructionSlot<Instruction> array = new InstructionSlot(this);
    private final InstructionSlot<Instruction> index = new InstructionSlot(this);

    public ArrayElementReference(Instruction array, Instruction index) {
        super(InsnOpcode.ARRAY_ELEMENT_REFERENCE);
        this.array.set(array);
        this.index.set(index);
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.MAY_THROW.toSet();
    }

    @Override
    public AType getType() {
        return ((ArrayType)this.array.get().getResultType()).getElementType();
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitArrayElementReference(this, ctx);
    }

    public Instruction getArray() {
        return this.array.get();
    }

    public Instruction getIndex() {
        return this.index.get();
    }
}

