/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.bytecode.InstructionSlot;
import net.covers1624.coffeegrinder.bytecode.insns.AbstractLoop;
import net.covers1624.coffeegrinder.bytecode.insns.BlockContainer;
import net.covers1624.coffeegrinder.bytecode.matching.LdcMatching;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.util.EnumBitSet;

public class DoWhileLoop
extends AbstractLoop {
    private final InstructionSlot<BlockContainer> body = new InstructionSlot(this);
    private final InstructionSlot<Instruction> condition = new InstructionSlot(this);

    public DoWhileLoop(BlockContainer body, Instruction condition) {
        super(InsnOpcode.DO_WHILE);
        this.condition.set(condition);
        this.body.set(body);
    }

    @Override
    public AType getResultType() {
        return PrimitiveType.VOID;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.NONE;
    }

    @Override
    protected EnumBitSet<InstructionFlag> computeFlags() {
        EnumBitSet<InstructionFlag> flags = super.computeFlags();
        if (LdcMatching.matchLdcBoolean(this.getCondition(), true) == null) {
            flags.clear(InstructionFlag.END_POINT_UNREACHABLE);
        }
        return flags;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitDoWhileLoop(this, ctx);
    }

    public Instruction getCondition() {
        return this.condition.get();
    }

    public void setCondition(Instruction condition) {
        this.condition.set(condition);
    }

    @Override
    public BlockContainer getBody() {
        return this.body.get();
    }
}

