/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.debug;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ServiceLoader;
import net.covers1624.coffeegrinder.bytecode.VariableLivenessGraph;
import net.covers1624.coffeegrinder.bytecode.flow.ControlFlowNode;
import net.covers1624.coffeegrinder.util.resolver.ClassResolver;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.util.SneakyUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Debugger {
    @Nullable
    public static final Debugger DEBUGGER = (Debugger)FastStream.of(ServiceLoader.load(Debugger.class)).firstOrDefault();

    public void writeControlFlowGraph(ControlFlowNode var1, Path var2) throws IOException;

    public String buildControlFlowGraphDot(ControlFlowNode var1);

    public void writeVariableLivenessGraph(VariableLivenessGraph var1, Path var2) throws IOException;

    public String buildVariableLivenessGraphDot(VariableLivenessGraph var1);

    public void startDebugger(String var1, ClassResolver var2);

    public static void tryIfPresent(SneakyUtils.ThrowingConsumer<Debugger, Throwable> action) {
        if (DEBUGGER != null) {
            try {
                action.accept((Object)DEBUGGER);
            }
            catch (Throwable ex) {
                Internal.LOGGER.error("Error running debugger action.", ex);
            }
            return;
        }
        Internal.LOGGER.warn("Debugger is not present.", new Throwable());
    }

    public static class Internal {
        private static final Logger LOGGER = LoggerFactory.getLogger(Debugger.class);
    }
}

