package net.covers1624.coffeegrinder.bytecode;

import net.covers1624.coffeegrinder.util.EnumBitSet;
import org.jetbrains.annotations.Nullable;

/**
 * Created by covers1624 on 22/2/21.
 */
public enum InstructionFlag {

    /**
     * The {@link Instruction} may throw an exception.
     */
    MAY_THROW,
    /**
     * The {@link Instruction} may exit with a branch or leave.
     */
    MAY_BRANCH,
    /**
     * The {@link Instruction} performs unconditional control flow, so that its endpoint is unreachable.
     * <p>
     * If {@link #END_POINT_UNREACHABLE} is set, either {@link #MAY_THROW} or {@link #MAY_BRANCH}
     * should also be set (unless the instruction represents an infinite loop).
     */
    END_POINT_UNREACHABLE,
    ;

    @Nullable
    private EnumBitSet<InstructionFlag> flags;

    public EnumBitSet<InstructionFlag> toSet() {
        if (flags == null) {
            flags = EnumBitSet.of(this);
        }
        return flags;
    }

    /**
     * Absolute value specifying the current flags are invalid and must be re validated.
     */
    @Nullable
    public static final EnumBitSet<InstructionFlag> INVALID_FLAGS = null;

    /**
     * No flags exist.
     */
    public static final EnumBitSet<InstructionFlag> NONE = EnumBitSet.noneOf(InstructionFlag.class);

}
