package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.*;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.util.EnumBitSet;

/**
 * Created by covers1624 on 7/5/24.
 */
public class Compare extends Instruction {

    private final Kind kind;
    private final InstructionSlot<Instruction> left = new InstructionSlot<>(this);
    private final InstructionSlot<Instruction> right = new InstructionSlot<>(this);

    public Compare(Kind kind, Instruction left, Instruction right) {
        super(InsnOpcode.COMPARE);
        this.kind = kind;
        this.left.set(left);
        this.right.set(right);
    }

    @Override
    public AType getResultType() {
        return PrimitiveType.INT;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.NONE;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitCompare(this, ctx);
    }

    public Kind getKind() {
        return kind;
    }

    public Instruction getLeft() {
        return left.get();
    }

    public Instruction getRight() {
        return right.get();
    }

    public enum Kind {
        LONG,  //                             a > b ? 1 : a == b ? 0 : -1
        NAN_L, // isNan(a) || isNan(b) ? -1 : a > b ? 1 : a == b ? 0 : -1;
        NAN_G, // isNan(a) || isNan(b) ?  1 : a > b ? 1 : a == b ? 0 : -1;
    }
}
